/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.rgbe.RgbeImagingParameters;
import org.apache.commons.imaging.formats.rgbe.RgbeInfo;

public class RgbeImageParser
extends ImageParser<RgbeImagingParameters> {
    @Override
    protected String[] getAcceptedExtensions() {
        return ImageFormats.RGBE.getExtensions();
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.RGBE};
    }

    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, RgbeImagingParameters params) throws ImagingException, IOException {
        try (RgbeInfo info = new RgbeInfo(byteSource);){
            DataBufferFloat buffer = new DataBufferFloat(info.getPixelData(), info.getWidth() * info.getHeight());
            BufferedImage bufferedImage = new BufferedImage(new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, buffer.getDataType()), Raster.createWritableRaster(new BandedSampleModel(buffer.getDataType(), info.getWidth(), info.getHeight(), 3), buffer, new Point()), false, null);
            return bufferedImage;
        }
    }

    @Override
    public String getDefaultExtension() {
        return ImageFormats.RGBE.getDefaultExtension();
    }

    @Override
    public RgbeImagingParameters getDefaultParameters() {
        return new RgbeImagingParameters();
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, RgbeImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, RgbeImagingParameters params) throws ImagingException, IOException {
        try (RgbeInfo info = new RgbeInfo(byteSource);){
            ImageInfo imageInfo = new ImageInfo(this.getName(), 32, new ArrayList<String>(), ImageFormats.RGBE, this.getName(), info.getHeight(), "image/vnd.radiance", 1, -1, -1.0f, -1, -1.0f, info.getWidth(), false, false, false, ImageInfo.ColorType.RGB, ImageInfo.CompressionAlgorithm.ADAPTIVE_RLE);
            return imageInfo;
        }
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, RgbeImagingParameters params) throws ImagingException, IOException {
        try (RgbeInfo info = new RgbeInfo(byteSource);){
            Dimension dimension = new Dimension(info.getWidth(), info.getHeight());
            return dimension;
        }
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, RgbeImagingParameters params) throws ImagingException, IOException {
        try (RgbeInfo info = new RgbeInfo(byteSource);){
            ImageMetadata imageMetadata = info.getMetadata();
            return imageMetadata;
        }
    }

    @Override
    public String getName() {
        return "Radiance HDR";
    }
}

