/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.internal;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.bytesource.ByteSource;

public class ImageParserFactory {
    public static <T extends ImagingParameters<T>> ImageParser<T> getImageParser(ByteSource byteSource) throws IOException {
        ImageFormat format = Imaging.guessFormat(byteSource);
        if (!format.equals(ImageFormats.UNKNOWN)) {
            return ImageParserFactory.getImageParser(format);
        }
        String fileName = byteSource.getFileName();
        if (fileName != null) {
            return ImageParserFactory.getImageParser(fileName);
        }
        throw new IllegalArgumentException("Can't parse this format.");
    }

    public static <T extends ImagingParameters<T>> ImageParser<T> getImageParser(ImageFormat format) {
        return ImageParserFactory.getImageParser(parser -> parser.canAcceptType(format), () -> new IllegalArgumentException("Unknown ImageFormat: " + format));
    }

    private static <T extends ImagingParameters<T>> ImageParser<T> getImageParser(Predicate<ImageParser<?>> pred, Supplier<? extends RuntimeException> supplier) {
        return ImageParser.getAllImageParsers().stream().filter(pred).findFirst().orElseThrow(supplier);
    }

    public static <T extends ImagingParameters<T>> ImageParser<T> getImageParser(String fileExtension) {
        return ImageParserFactory.getImageParser(parser -> parser.canAcceptExtension(fileExtension), () -> new IllegalArgumentException("Unknown extension: " + fileExtension));
    }

    private ImageParserFactory() {
    }
}

