/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.mylzw;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.mylzw.MyBitInputStream;

public final class MyLzwDecompressor {
    private static final int MAX_TABLE_SIZE = 4096;
    private final byte[][] table;
    private int codeSize;
    private final int initialCodeSize;
    private int codes = -1;
    private final ByteOrder byteOrder;
    private final Listener listener;
    private final int clearCode;
    private final int eoiCode;
    private int written;
    private final boolean tiffLZWMode;

    public MyLzwDecompressor(int initialCodeSize, ByteOrder byteOrder, boolean tiffLZWMode) throws ImagingException {
        this(initialCodeSize, byteOrder, tiffLZWMode, null);
    }

    public MyLzwDecompressor(int initialCodeSize, ByteOrder byteOrder, boolean tiffLZWMode, Listener listener) throws ImagingException {
        this.listener = listener;
        this.byteOrder = byteOrder;
        this.tiffLZWMode = tiffLZWMode;
        this.initialCodeSize = initialCodeSize;
        this.table = new byte[4096][];
        this.clearCode = 1 << initialCodeSize;
        this.eoiCode = this.clearCode + 1;
        if (null != listener) {
            listener.init(this.clearCode, this.eoiCode);
        }
        this.initializeTable();
    }

    private void addStringToTable(byte[] bytes) {
        if (this.codes < 1 << this.codeSize) {
            this.table[this.codes] = bytes;
            ++this.codes;
        }
        this.checkCodeSize();
    }

    private byte[] appendBytes(byte[] bytes, byte b) {
        byte[] result = Arrays.copyOf(bytes, bytes.length + 1);
        result[result.length - 1] = b;
        return result;
    }

    private void checkCodeSize() {
        int limit = 1 << this.codeSize;
        if (this.tiffLZWMode) {
            --limit;
        }
        if (this.codes == limit) {
            this.incrementCodeSize();
        }
    }

    private void clearTable() {
        this.codes = (1 << this.initialCodeSize) + 2;
        this.codeSize = this.initialCodeSize;
        this.incrementCodeSize();
    }

    /*
     * Exception decompiling
     */
    public byte[] decompress(InputStream is, int expectedLength) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte firstChar(byte[] bytes) {
        return bytes[0];
    }

    private int getNextCode(MyBitInputStream is) throws IOException {
        int code = is.readBits(this.codeSize);
        if (null != this.listener) {
            this.listener.code(code);
        }
        return code;
    }

    private void incrementCodeSize() {
        if (this.codeSize != 12) {
            ++this.codeSize;
        }
    }

    private void initializeTable() throws ImagingException {
        this.codeSize = this.initialCodeSize;
        int initialEntriesCount = 1 << this.codeSize + 2;
        if (initialEntriesCount > this.table.length) {
            throw new ImagingException(String.format("Invalid Lzw table length [%d]; entries count is [%d]", this.table.length, initialEntriesCount));
        }
        for (int i = 0; i < initialEntriesCount; ++i) {
            this.table[i] = new byte[]{(byte)i};
        }
    }

    private boolean isInTable(int code) {
        return code < this.codes;
    }

    private byte[] stringFromCode(int code) throws ImagingException {
        if (code >= this.codes || code < 0) {
            throw new ImagingException("Bad Code: " + code + " codes: " + this.codes + " code_size: " + this.codeSize + ", table: " + this.table.length);
        }
        return this.table[code];
    }

    private void writeToResult(OutputStream os, byte[] bytes) throws IOException {
        os.write(bytes);
        this.written += bytes.length;
    }

    public static interface Listener {
        public void code(int var1);

        public void init(int var1, int var2);
    }
}

