/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.meta;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.meta.JdbcType;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Column
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 577527740359719367L;
    private String tableName;
    private String name;
    private int type;
    private String typeName;
    private int size;
    private boolean isNullable;
    private String comment;

    public static Column create(String tableName, ResultSet columnMetaRs) {
        return new Column(tableName, columnMetaRs);
    }

    public Column() {
    }

    public Column(String tableName, ResultSet columnMetaRs) {
        try {
            this.init(tableName, columnMetaRs);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(StrUtil.format((CharSequence)"Get table [{}] meta info error!", tableName));
        }
    }

    public void init(String tableName, ResultSet columnMetaRs) throws SQLException {
        this.tableName = tableName;
        this.name = columnMetaRs.getString("COLUMN_NAME");
        this.type = columnMetaRs.getInt("DATA_TYPE");
        this.typeName = columnMetaRs.getString("TYPE_NAME");
        this.size = columnMetaRs.getInt("COLUMN_SIZE");
        this.isNullable = columnMetaRs.getBoolean("NULLABLE");
        this.comment = columnMetaRs.getString("REMARKS");
    }

    public String getTableName() {
        return this.tableName;
    }

    public Column setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public JdbcType getTypeEnum() {
        return JdbcType.valueOf(this.type);
    }

    public int getType() {
        return this.type;
    }

    public Column setType(int type) {
        this.type = type;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Column setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Column setSize(int size) {
        this.size = size;
        return this;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Column setNullable(boolean isNullable) {
        this.isNullable = isNullable;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Column setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String toString() {
        return "Column [tableName=" + this.tableName + ", name=" + this.name + ", type=" + this.type + ", size=" + this.size + ", isNullable=" + this.isNullable + "]";
    }
}

