/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.tokenizer.engine.jcseg;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.tokenizer.Result;
import cn.hutool.extra.tokenizer.TokenizerEngine;
import cn.hutool.extra.tokenizer.TokenizerException;
import cn.hutool.extra.tokenizer.engine.jcseg.JcsegResult;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;

public class JcsegEngine
implements TokenizerEngine {
    private ISegment segment;

    public JcsegEngine() {
        JcsegTaskConfig config = new JcsegTaskConfig(true);
        ADictionary dic = DictionaryFactory.createSingletonDictionary((JcsegTaskConfig)config);
        try {
            this.segment = SegmentFactory.createJcseg((int)2, (Object[])new Object[]{config, dic});
        }
        catch (JcsegException e) {
            throw new TokenizerException(e);
        }
    }

    public JcsegEngine(ISegment segment) {
        this.segment = segment;
    }

    @Override
    public Result parse(CharSequence text) {
        try {
            this.segment.reset((Reader)new StringReader(StrUtil.str(text)));
        }
        catch (IOException e) {
            throw new TokenizerException(e);
        }
        return new JcsegResult(this.segment);
    }
}

