/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.alarm;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.AlarmInfoConverter;
import com.aizuda.snailjob.server.common.alarm.AbstractAlarm;
import com.aizuda.snailjob.server.common.dto.JobAlarmInfo;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.JobBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractJobAlarm<E extends ApplicationEvent>
extends AbstractAlarm<E, JobAlarmInfo> {
    @Autowired
    private JobTaskBatchMapper jobTaskBatchMapper;

    @Override
    protected Map<Long, List<JobAlarmInfo>> convertAlarmDTO(List<JobAlarmInfo> jobAlarmInfoList, Set<Integer> notifyScene) {
        HashMap<Long, List<JobAlarmInfo>> jobAlarmInfoMap = new HashMap<Long, List<JobAlarmInfo>>();
        jobAlarmInfoList.forEach(i -> notifyScene.add(i.getNotifyScene()));
        Map jobAlarmInfoGroupMap = StreamUtils.toIdentityMap(jobAlarmInfoList, JobAlarmInfo::getId);
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"batch.id", (Collection)StreamUtils.toSet(jobAlarmInfoList, JobAlarmInfo::getId))).eq((Object)"batch.deleted", (Object)0);
        List jobBatchResponseDOList = this.jobTaskBatchMapper.selectJobBatchListByIds((Wrapper)wrapper);
        for (JobBatchResponseDO jobBatchResponseDO : jobBatchResponseDOList) {
            HashSet jobNotifyIds = StrUtil.isBlank((CharSequence)jobBatchResponseDO.getNotifyIds()) ? new HashSet() : new HashSet(JsonUtil.parseList((String)jobBatchResponseDO.getNotifyIds(), Long.class));
            for (Long jobNotifyId : jobNotifyIds) {
                JobAlarmInfo jobAlarmInfo = AlarmInfoConverter.INSTANCE.toJobAlarmInfo(jobBatchResponseDO);
                JobAlarmInfo alarmInfo = (JobAlarmInfo)jobAlarmInfoGroupMap.get(jobBatchResponseDO.getId());
                jobAlarmInfo.setReason(alarmInfo.getReason());
                jobAlarmInfo.setNotifyScene(alarmInfo.getNotifyScene());
                List<JobAlarmInfo> jobAlarmInfos = jobAlarmInfoMap.getOrDefault(jobNotifyId, Lists.newArrayList());
                jobAlarmInfos.add(jobAlarmInfo);
                jobAlarmInfoMap.put(jobNotifyId, jobAlarmInfos);
            }
        }
        return jobAlarmInfoMap;
    }
}

