/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.mcp.register;

import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.cloud.ai.mcp.register.NacosMcpRegister;
import com.alibaba.cloud.ai.mcp.register.NacosMcpRegisterProperties;
import com.alibaba.nacos.api.exception.NacosException;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.Properties;
import org.springframework.ai.mcp.server.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={NacosMcpRegisterProperties.class, NacosMcpProperties.class, McpServerProperties.class})
@AutoConfiguration(after={McpServerAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.nacos.register", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class NacosMcpRegisterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={NacosMcpOperationService.class})
    public NacosMcpOperationService nacosMcpOperationService(NacosMcpProperties nacosMcpProperties) {
        Properties nacosProperties = nacosMcpProperties.getNacosProperties();
        try {
            return new NacosMcpOperationService(nacosProperties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    @ConditionalOnBean(value={McpSyncServer.class})
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.nacos.register", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public NacosMcpRegister nacosMcpRegisterSync(NacosMcpOperationService nacosMcpOperationService, McpSyncServer mcpSyncServer, NacosMcpProperties nacosMcpProperties, NacosMcpRegisterProperties nacosMcpRegistryProperties, McpServerProperties mcpServerProperties, McpServerTransportProvider mcpServerTransport) {
        McpAsyncServer mcpAsyncServer = mcpSyncServer.getAsyncServer();
        return this.getNacosMcpRegister(nacosMcpOperationService, mcpAsyncServer, nacosMcpProperties, nacosMcpRegistryProperties, mcpServerProperties, mcpServerTransport);
    }

    @Bean
    @ConditionalOnBean(value={McpAsyncServer.class})
    @ConditionalOnProperty(prefix="spring.ai.alibaba.mcp.nacos.register", name={"enabled"}, havingValue="true", matchIfMissing=false)
    public NacosMcpRegister nacosMcpRegisterAsync(NacosMcpOperationService nacosMcpOperationService, McpAsyncServer mcpAsyncServer, NacosMcpProperties nacosMcpProperties, NacosMcpRegisterProperties nacosMcpRegistryProperties, McpServerProperties mcpServerProperties, McpServerTransportProvider mcpServerTransport) {
        return this.getNacosMcpRegister(nacosMcpOperationService, mcpAsyncServer, nacosMcpProperties, nacosMcpRegistryProperties, mcpServerProperties, mcpServerTransport);
    }

    private NacosMcpRegister getNacosMcpRegister(NacosMcpOperationService nacosMcpOperationService, McpAsyncServer mcpAsyncServer, NacosMcpProperties nacosMcpProperties, NacosMcpRegisterProperties nacosMcpRegistryProperties, McpServerProperties mcpServerProperties, McpServerTransportProvider mcpServerTransport) {
        if (mcpServerTransport instanceof StdioServerTransportProvider) {
            return new NacosMcpRegister(nacosMcpOperationService, mcpAsyncServer, nacosMcpProperties, nacosMcpRegistryProperties, mcpServerProperties, "stdio");
        }
        return new NacosMcpRegister(nacosMcpOperationService, mcpAsyncServer, nacosMcpProperties, nacosMcpRegistryProperties, mcpServerProperties, "mcp-sse");
    }
}

