/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.ChatMemoryAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.MemcachedChatMemoryProperties;
import com.alibaba.cloud.ai.memory.memcached.MemcachedChatMemoryRepository;
import com.alibaba.cloud.ai.toolcalling.memcached.MemcachedService;
import java.io.IOException;
import java.net.InetSocketAddress;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={ChatMemoryAutoConfiguration.class})
@ConditionalOnClass(value={MemcachedChatMemoryRepository.class, MemcachedClient.class})
@EnableConfigurationProperties(value={MemcachedChatMemoryProperties.class})
public class MemcachedChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedChatMemoryAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MemcachedChatMemoryRepository memcachedChatMemoryRepository(MemcachedChatMemoryProperties properties) throws IOException {
        MemcachedClient memcachedClient = new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(properties.getHost(), properties.getPort())});
        logger.info("Configuring Memcached chat memory repository");
        return new MemcachedChatMemoryRepository(new MemcachedService(memcachedClient));
    }
}

