/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.ChatMemoryAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.MongoDBChatMemoryProperties;
import com.alibaba.cloud.ai.memory.mongodb.MongoDBChatMemoryRepository;
import com.mongodb.client.MongoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={ChatMemoryAutoConfiguration.class})
@ConditionalOnClass(value={MongoDBChatMemoryRepository.class, MongoClient.class})
@EnableConfigurationProperties(value={MongoDBChatMemoryProperties.class})
public class MongoDBChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBChatMemoryAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MongoDBChatMemoryRepository mongoChatMemoryRepository(MongoDBChatMemoryProperties properties) {
        logger.info("Configuring MongoDB chat memory repository");
        return MongoDBChatMemoryRepository.builder().host(properties.getHost()).port(properties.getPort()).authDatabaseName(properties.getAuthDatabaseName()).databaseName(properties.getDatabaseName()).userName(properties.getUserName()).password(properties.getPassword()).build();
    }
}

