/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.TablestoreChatMemoryProperties;
import com.alibaba.cloud.ai.memory.tablestore.TablestoreChatMemoryRepository;
import com.alicloud.openservices.tablestore.SyncClient;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={TablestoreChatMemoryRepository.class, SyncClient.class})
@EnableConfigurationProperties(value={TablestoreChatMemoryProperties.class})
@ConditionalOnProperty(prefix="spring.ai.memory.tablestore", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class TablestoreChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TablestoreChatMemoryAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    SyncClient tablestoreSyncClient(TablestoreChatMemoryProperties properties) {
        return new SyncClient(properties.getEndpoint(), properties.getAccessKeyId(), properties.getAccessKeySecret(), properties.getInstanceName());
    }

    @Bean
    @ConditionalOnMissingBean
    TablestoreChatMemoryRepository tablestoreChatMemoryRepository(SyncClient syncClient, TablestoreChatMemoryProperties properties) {
        logger.info("Configuring Tablestore chat memory repository");
        return new TablestoreChatMemoryRepository(syncClient, properties.getSessionTableName(), properties.getSessionSecondaryIndexName(), Collections.emptyList(), properties.getMessageTableName(), properties.getMessageSecondaryIndexName());
    }
}

