/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory.redis;

import com.alibaba.cloud.ai.autoconfigure.memory.ChatMemoryAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryClusterConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionDetails;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryProperties;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryStandaloneConfiguration;
import com.alibaba.cloud.ai.memory.redis.JedisRedisChatMemoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.Jedis;

@AutoConfiguration(before={ChatMemoryAutoConfiguration.class})
@ConditionalOnClass(value={JedisRedisChatMemoryRepository.class, Jedis.class})
@EnableConfigurationProperties(value={RedisChatMemoryProperties.class})
@ConditionalOnProperty(name={"spring.ai.memory.redis.client-type"}, havingValue="jedis")
public class JedisRedisChatMemoryConnectionAutoConfiguration
extends RedisChatMemoryConnectionAutoConfiguration<JedisRedisChatMemoryRepository> {
    private static final Logger logger = LoggerFactory.getLogger(JedisRedisChatMemoryConnectionAutoConfiguration.class);

    public JedisRedisChatMemoryConnectionAutoConfiguration(RedisChatMemoryProperties properties, RedisChatMemoryConnectionDetails connectionDetails) {
        super(properties, connectionDetails);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    protected JedisRedisChatMemoryRepository buildRedisChatMemoryRepository() {
        return (JedisRedisChatMemoryRepository)super.buildRedisChatMemoryRepository();
    }

    @Override
    protected JedisRedisChatMemoryRepository createStandaloneChatMemoryRepository(RedisChatMemoryStandaloneConfiguration standaloneConfiguration) {
        logger.info("Configuring Redis Standalone chat memory repository using Jedis");
        return JedisRedisChatMemoryRepository.builder().host(standaloneConfiguration.hostName()).port(standaloneConfiguration.port()).username(standaloneConfiguration.username()).password(standaloneConfiguration.password()).timeout(standaloneConfiguration.timeout()).build();
    }

    @Override
    protected JedisRedisChatMemoryRepository createClusterChatMemoryRepository(RedisChatMemoryClusterConfiguration clusterConfiguration) {
        logger.info("Configuring Redis Cluster chat memory repository using Jedis");
        return JedisRedisChatMemoryRepository.builder().nodes(clusterConfiguration.nodeAddresses()).username(clusterConfiguration.username()).password(clusterConfiguration.password()).timeout(clusterConfiguration.timeout()).build();
    }
}

