/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory.redis;

import com.alibaba.cloud.ai.autoconfigure.memory.ChatMemoryAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryClusterConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionDetails;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryProperties;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryStandaloneConfiguration;
import com.alibaba.cloud.ai.memory.redis.RedissonRedisChatMemoryRepository;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={ChatMemoryAutoConfiguration.class})
@ConditionalOnClass(value={RedissonRedisChatMemoryRepository.class, RedissonClient.class})
@EnableConfigurationProperties(value={RedisChatMemoryProperties.class})
@ConditionalOnProperty(name={"spring.ai.memory.redis.client-type"}, havingValue="redisson")
public class RedissonRedisChatMemoryConnectionAutoConfiguration
extends RedisChatMemoryConnectionAutoConfiguration<RedissonRedisChatMemoryRepository> {
    private static final Logger logger = LoggerFactory.getLogger(RedissonRedisChatMemoryConnectionAutoConfiguration.class);

    public RedissonRedisChatMemoryConnectionAutoConfiguration(RedisChatMemoryProperties properties, RedisChatMemoryConnectionDetails connectionDetails) {
        super(properties, connectionDetails);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    protected RedissonRedisChatMemoryRepository buildRedisChatMemoryRepository() {
        return (RedissonRedisChatMemoryRepository)super.buildRedisChatMemoryRepository();
    }

    @Override
    protected RedissonRedisChatMemoryRepository createStandaloneChatMemoryRepository(RedisChatMemoryStandaloneConfiguration standaloneConfiguration) {
        logger.info("Configuring Redis Standalone chat memory repository using Redisson");
        return RedissonRedisChatMemoryRepository.builder().host(standaloneConfiguration.hostName()).port(standaloneConfiguration.port()).username(standaloneConfiguration.username()).password(standaloneConfiguration.password()).timeout(standaloneConfiguration.timeout()).build();
    }

    @Override
    protected RedissonRedisChatMemoryRepository createClusterChatMemoryRepository(RedisChatMemoryClusterConfiguration clusterConfiguration) {
        logger.info("Configuring Redis Cluster chat memory repository using Redisson");
        return RedissonRedisChatMemoryRepository.builder().nodes(clusterConfiguration.nodeAddresses()).username(clusterConfiguration.username()).password(clusterConfiguration.password()).timeout(clusterConfiguration.timeout()).build();
    }
}

