/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.alibaba.cloud.ai.autoconfigure.memory.ElasticsearchChatMemoryProperties;
import com.alibaba.cloud.ai.memory.elasticsearch.ElasticsearchChatMemoryRepository;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={ElasticsearchChatMemoryRepository.class, ElasticsearchClient.class})
@ConditionalOnProperty(prefix="spring.ai.memory.elasticsearch", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={ElasticsearchChatMemoryProperties.class})
public class ElasticsearchChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="elasticsearchChatMemoryRepository")
    @ConditionalOnMissingBean(name={"elasticsearchChatMemoryRepository"})
    ElasticsearchChatMemoryRepository elasticsearchChatMemoryRepository(ElasticsearchChatMemoryProperties properties) throws Exception {
        logger.info("Configuring elasticsearch chat memory repository");
        HttpHost[] httpHosts = !CollectionUtils.isEmpty(properties.getNodes()) ? (HttpHost[])properties.getNodes().stream().map(node -> {
            String[] parts = node.split(":");
            return new HttpHost(parts[0], Integer.parseInt(parts[1]), properties.getScheme());
        }).toArray(HttpHost[]::new) : new HttpHost[]{new HttpHost(properties.getHost(), properties.getPort(), properties.getScheme())};
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        if (StringUtils.hasText((String)properties.getUsername()) && StringUtils.hasText((String)properties.getPassword())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(properties.getUsername(), properties.getPassword()));
            if ("https".equalsIgnoreCase(properties.getScheme())) {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (chains, authType) -> true).build();
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchChatMemoryAutoConfiguration.lambda$elasticsearchChatMemoryRepository$3((CredentialsProvider)credentialsProvider, sslContext, arg_0));
            } else {
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchChatMemoryAutoConfiguration.lambda$elasticsearchChatMemoryRepository$4((CredentialsProvider)credentialsProvider, arg_0));
            }
        }
        RestClientTransport transport = new RestClientTransport(restClientBuilder.build(), (JsonpMapper)new JacksonJsonpMapper());
        ElasticsearchClient elasticsearchClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        return new ElasticsearchChatMemoryRepository(elasticsearchClient);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchChatMemoryRepository$4(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchChatMemoryRepository$3(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

