/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.H2ChatMemoryProperties;
import com.alibaba.cloud.ai.memory.jdbc.H2ChatMemoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={H2ChatMemoryRepository.class, JdbcTemplate.class})
@ConditionalOnProperty(prefix="spring.ai.memory.h2", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={H2ChatMemoryProperties.class})
public class H2ChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(H2ChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="h2ChatMemoryRepository")
    @ConditionalOnMissingBean(name={"h2ChatMemoryRepository"})
    H2ChatMemoryRepository h2ChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        logger.info("Configuring H2 chat memory repository");
        return H2ChatMemoryRepository.h2Builder().jdbcTemplate(jdbcTemplate).build();
    }
}

