/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory;

import com.alibaba.cloud.ai.autoconfigure.memory.SQLiteChatMemoryProperties;
import com.alibaba.cloud.ai.memory.jdbc.SQLiteChatMemoryRepository;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={SQLiteChatMemoryRepository.class, DataSource.class, JdbcTemplate.class})
@ConditionalOnProperty(prefix="spring.ai.memory.sqlite", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={SQLiteChatMemoryProperties.class})
public class SQLiteChatMemoryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SQLiteChatMemoryAutoConfiguration.class);

    @Bean
    @Qualifier(value="sqliteChatMemoryRepository")
    @ConditionalOnMissingBean(name={"sqliteChatMemoryRepository"})
    SQLiteChatMemoryRepository sqliteChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        logger.info("Configuring SQLite chat memory repository");
        return SQLiteChatMemoryRepository.sqliteBuilder().jdbcTemplate(jdbcTemplate).build();
    }
}

