/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.discovery.client.tool;

import com.alibaba.cloud.ai.mcp.discovery.client.tool.LoadbalancedAsyncMcpToolCallback;
import com.alibaba.cloud.ai.mcp.discovery.client.transport.LoadbalancedMcpAsyncClient;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.util.Assert;

public class LoadbalancedAsyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<LoadbalancedMcpAsyncClient> mcpClients;
    private final BiPredicate<McpAsyncClient, McpSchema.Tool> toolFilter;

    public LoadbalancedAsyncMcpToolCallbackProvider(BiPredicate<McpAsyncClient, McpSchema.Tool> toolFilter, List<LoadbalancedMcpAsyncClient> mcpClients) {
        Assert.notNull(mcpClients, (String)"MCP clients must not be null");
        Assert.notNull(toolFilter, (String)"Tool filter must not be null");
        this.mcpClients = mcpClients;
        this.toolFilter = toolFilter;
    }

    public LoadbalancedAsyncMcpToolCallbackProvider(List<LoadbalancedMcpAsyncClient> mcpClients) {
        this((mcpClient, tool) -> true, mcpClients);
    }

    public ToolCallback[] getToolCallbacks() {
        ArrayList<ToolCallback> toolCallbackList = new ArrayList<ToolCallback>();
        for (LoadbalancedMcpAsyncClient mcpClient : this.mcpClients) {
            ToolCallback[] toolCallbacks = (ToolCallback[])mcpClient.listTools().map(response -> (ToolCallback[])response.tools().stream().filter(tool -> this.toolFilter.test(mcpClient.getMcpAsyncClient(), (McpSchema.Tool)tool)).map(tool -> new LoadbalancedAsyncMcpToolCallback(mcpClient, (McpSchema.Tool)tool)).toArray(ToolCallback[]::new)).block();
            this.validateToolCallbacks(toolCallbacks);
            toolCallbackList.addAll(List.of(toolCallbacks));
        }
        return toolCallbackList.toArray(new ToolCallback[0]);
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((ToolCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }
}

