/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.dto.schema.SchemaDTO;
import com.alibaba.cloud.ai.enums.StreamResponseType;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.alibaba.cloud.ai.model.execution.ExecutionStep;
import com.alibaba.cloud.ai.node.AbstractPlanBasedNode;
import com.alibaba.cloud.ai.prompt.PromptHelper;
import com.alibaba.cloud.ai.service.base.BaseNl2SqlService;
import com.alibaba.cloud.ai.util.StateUtils;
import com.alibaba.cloud.ai.util.StreamingChatGeneratorUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

public class SemanticConsistencyNode
extends AbstractPlanBasedNode {
    private static final Logger logger = LoggerFactory.getLogger(SemanticConsistencyNode.class);
    private final BaseNl2SqlService baseNl2SqlService;

    public SemanticConsistencyNode(BaseNl2SqlService baseNl2SqlService) {
        this.baseNl2SqlService = baseNl2SqlService;
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        this.logNodeEntry();
        List<String> evidenceList = StateUtils.getListValue(state, "EVIDENCES");
        SchemaDTO schemaDTO = StateUtils.getObjectValue(state, "TABLE_RELATION_OUTPUT", SchemaDTO.class);
        ExecutionStep executionStep = this.getCurrentExecutionStep(state);
        Integer currentStep = this.getCurrentStepNumber(state);
        ExecutionStep.ToolParameters toolParameters = executionStep.getToolParameters();
        String sqlQuery = toolParameters.getSqlQuery();
        logger.info("Starting semantic consistency validation - SQL: {}", (Object)sqlQuery);
        logger.info("Step description: {}", (Object)toolParameters.getDescription());
        Flux<ChatResponse> validationResultFlux = this.performSemanticValidationStream(schemaDTO, evidenceList, toolParameters, sqlQuery);
        AsyncGenerator<? extends NodeOutput> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, "\u5f00\u59cb\u8bed\u4e49\u4e00\u81f4\u6027\u6821\u9a8c", "\u8bed\u4e49\u4e00\u81f4\u6027\u6821\u9a8c\u5b8c\u6210", validationResult -> {
            boolean isPassed = !validationResult.startsWith("\u4e0d\u901a\u8fc7");
            Map<String, Object> result = this.buildValidationResult(isPassed, (String)validationResult, currentStep);
            logger.info("[{}] Semantic consistency validation result: {}, passed: {}", new Object[]{this.getClass().getSimpleName(), validationResult, isPassed});
            return result;
        }, validationResultFlux, StreamResponseType.VALIDATION);
        return Map.of("SEMANTIC_CONSISTENCY_NODE_OUTPUT", generator);
    }

    private String performSemanticValidation(SchemaDTO schemaDTO, List<String> evidenceList, ExecutionStep.ToolParameters toolParameters, String sqlQuery) throws Exception {
        String schema = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String evidence = StringUtils.join(evidenceList, (String)";\n");
        String context = String.join((CharSequence)"\n", schema, evidence, toolParameters.getDescription());
        return this.baseNl2SqlService.semanticConsistency(sqlQuery, context);
    }

    private Flux<ChatResponse> performSemanticValidationStream(SchemaDTO schemaDTO, List<String> evidenceList, ExecutionStep.ToolParameters toolParameters, String sqlQuery) throws Exception {
        String schema = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String evidence = StringUtils.join(evidenceList, (String)";\n");
        String context = String.join((CharSequence)"\n", schema, evidence, toolParameters.getDescription());
        return this.baseNl2SqlService.semanticConsistencyStream(sqlQuery, context);
    }

    private Map<String, Object> buildValidationResult(boolean passed, String validationResult, Integer currentStep) {
        if (passed) {
            return Map.of("SEMANTIC_CONSISTENCY_NODE_OUTPUT", true, "PLAN_CURRENT_STEP", currentStep + 1);
        }
        return Map.of("SEMANTIC_CONSISTENCY_NODE_OUTPUT", false, "SEMANTIC_CONSISTENCY_NODE_RECOMMEND_OUTPUT", validationResult);
    }
}

