/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.dto.PromptConfigDTO;
import com.alibaba.cloud.ai.entity.UserPromptConfig;
import com.alibaba.cloud.ai.mapper.UserPromptConfigMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPromptConfigService {
    private static final Logger logger = LoggerFactory.getLogger(UserPromptConfigService.class);
    @Autowired
    private UserPromptConfigMapper userPromptConfigMapper;

    public UserPromptConfig saveOrUpdateConfig(PromptConfigDTO configDTO) {
        UserPromptConfig config;
        logger.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u63d0\u793a\u8bcd\u914d\u7f6e\uff1a{}", (Object)configDTO);
        if (configDTO.id() != null) {
            config = (UserPromptConfig)this.userPromptConfigMapper.selectById((Serializable)((Object)configDTO.id()));
            if (config != null) {
                config.setName(configDTO.name());
                config.setSystemPrompt(configDTO.systemPrompt());
                config.setEnabled(configDTO.enabled());
                config.setDescription(configDTO.description());
                this.userPromptConfigMapper.updateById(config);
            } else {
                config = new UserPromptConfig();
                config.setId(configDTO.id());
                config.setName(configDTO.name());
                config.setPromptType(configDTO.promptType());
                config.setSystemPrompt(configDTO.systemPrompt());
                config.setEnabled(configDTO.enabled());
                config.setDescription(configDTO.description());
                config.setCreator(configDTO.creator());
                this.userPromptConfigMapper.insert(config);
            }
        } else {
            config = new UserPromptConfig();
            config.setName(configDTO.name());
            config.setPromptType(configDTO.promptType());
            config.setSystemPrompt(configDTO.systemPrompt());
            config.setEnabled(configDTO.enabled());
            config.setDescription(configDTO.description());
            config.setCreator(configDTO.creator());
            this.userPromptConfigMapper.insert(config);
        }
        if (Boolean.TRUE.equals(config.getEnabled())) {
            this.userPromptConfigMapper.disableAllByPromptType(config.getPromptType());
            this.userPromptConfigMapper.enableById(config.getId());
            logger.info("\u5df2\u542f\u7528\u63d0\u793a\u8bcd\u7c7b\u578b [{}] \u7684\u914d\u7f6e\uff1a{}", (Object)config.getPromptType(), (Object)config.getId());
        }
        return config;
    }

    public UserPromptConfig getConfigById(String id) {
        return (UserPromptConfig)this.userPromptConfigMapper.selectById((Serializable)((Object)id));
    }

    public UserPromptConfig getActiveConfigByType(String promptType) {
        return this.userPromptConfigMapper.selectActiveByPromptType(promptType);
    }

    public List<UserPromptConfig> getAllConfigs() {
        return this.userPromptConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByDesc(UserPromptConfig::getUpdateTime));
    }

    public List<UserPromptConfig> getConfigsByType(String promptType) {
        return this.userPromptConfigMapper.selectByPromptType(promptType);
    }

    public boolean deleteConfig(String id) {
        int deleted;
        UserPromptConfig config = (UserPromptConfig)this.userPromptConfigMapper.selectById((Serializable)((Object)id));
        if (config != null && (deleted = this.userPromptConfigMapper.deleteById((Serializable)((Object)id))) > 0) {
            logger.info("\u5df2\u5220\u9664\u914d\u7f6e\uff1a{}", (Object)id);
            return true;
        }
        return false;
    }

    public boolean enableConfig(String id) {
        UserPromptConfig config = (UserPromptConfig)this.userPromptConfigMapper.selectById((Serializable)((Object)id));
        if (config != null) {
            this.userPromptConfigMapper.disableAllByPromptType(config.getPromptType());
            int updated = this.userPromptConfigMapper.enableById(id);
            if (updated > 0) {
                logger.info("\u5df2\u542f\u7528\u914d\u7f6e\uff1a{}", (Object)id);
                return true;
            }
        }
        return false;
    }

    public boolean disableConfig(String id) {
        int updated = this.userPromptConfigMapper.disableById(id);
        if (updated > 0) {
            logger.info("\u5df2\u7981\u7528\u914d\u7f6e\uff1a{}", (Object)id);
            return true;
        }
        return false;
    }

    public void disableConfigsByType(String promptType) {
        this.userPromptConfigMapper.disableAllByPromptType(promptType);
    }

    public String getCustomPromptContent(String promptType) {
        return null;
    }

    public boolean hasCustomConfig(String promptType) {
        return this.getActiveConfigByType(promptType) != null;
    }
}

