/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.semantic;

import com.alibaba.cloud.ai.dto.SemanticModelDTO;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SemanticModelRecallService {
    private static final String FIELD_GET_BY_DATASET_IDS = "SELECT\n    agent_id,\n\tfield_name,\n\tsynonyms,\n\torigin_name,\n\tdescription,\n\torigin_description,\n\ttype,\n\tis_recall,\n\tstatus\nFROM semantic_model WHERE agent_id = ? AND status = 1 AND is_recall = 1\n";
    private final JdbcTemplate jdbcTemplate;

    public SemanticModelRecallService(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"jdbcTemplate cannot be null");
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<SemanticModelDTO> getFieldByDataSetId(String dataSetId) {
        return this.jdbcTemplate.query(FIELD_GET_BY_DATASET_IDS, new Object[]{dataSetId}, (rs, rowNum) -> new SemanticModelDTO(rs.getString("agent_id"), rs.getString("origin_name"), rs.getString("field_name"), rs.getString("synonyms"), rs.getString("description"), rs.getObject("is_recall", Boolean.TYPE), rs.getObject("status", Boolean.TYPE), rs.getString("type"), rs.getString("origin_description")));
    }
}

