/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeUtil {
    public static final Pattern SPECIFIC_YEAR_MONTH_DAY_PATTERN = Pattern.compile("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5");
    public static final Pattern GENERAL_YEAR_MONTH_DAY_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)(\\d{2}\u6708\\d{2}\u65e5)");
    public static final Pattern GENERAL_MONTH_DAY_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708|\u4e0a\u4e0a\u6708|\u4e0b\u6708)(\\d{2}\u65e5)");
    public static final Pattern GENERAL_DAY_PATTERN = Pattern.compile("(\u4eca\u5929|\u6628\u5929|\u524d\u5929|\u660e\u5929|\u540e\u5929|\u4e0a\u6708\u4eca\u5929|\u4e0a\u4e0a\u6708\u4eca\u5929)");
    public static final Pattern WEEK_DAY_PATTERN = Pattern.compile("\u672c\u5468\u7b2c(\\d)\u5929");
    public static final Pattern GENERAL_MONTH_LAST_DAY_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708)\u6700\u540e\u4e00\u5929");
    public static final Pattern GENERAL_YEAR_MONTH_LAST_DAY_PATTERN = Pattern.compile("(\u4eca\u5e74)(\\d{2})\u6708\u6700\u540e\u4e00\u5929");
    public static final Pattern GENERAL_WEEK_SPECIFIC_DAY_PATTERN = Pattern.compile("(\u672c\u5468|\u4e0a\u5468|\u4e0a\u4e0a\u5468|\u4e0b\u5468|\u4e0b\u4e0b\u5468)\u661f\u671f(\\d)");
    public static final Pattern SPECIFIC_YEAR_MONTH_PATTERN = Pattern.compile("\\d{4}\u5e74\\d{2}\u6708");
    public static final Pattern GENERAL_YEAR_MONTH_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)(\\d{2}\u6708)");
    public static final Pattern GENERAL_MONTH_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708|\u4e0a\u4e0a\u6708|\u4e0b\u6708|\u53bb\u5e74\u672c\u6708)");
    public static final Pattern SPECIFIC_YEAR_PATTERN = Pattern.compile("(\\d{4})\u5e74");
    public static final Pattern GENERAL_YEAR_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)");
    public static final Pattern SPECIFIC_YEAR_QUARTER_PATTERN = Pattern.compile("\\d{4}\u5e74\u7b2c\\d\u5b63\u5ea6");
    public static final Pattern GENERAL_YEAR_QUARTER_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)(\u7b2c\\d\u5b63\u5ea6)");
    public static final Pattern GENERAL_QUARTER_PATTERN = Pattern.compile("(\u672c\u5b63\u5ea6|\u4e0a\u5b63\u5ea6|\u4e0b\u5b63\u5ea6|\u53bb\u5e74\u672c\u5b63\u5ea6)");
    public static final Pattern GENERAL_WEEK_PATTERN = Pattern.compile("(\u672c\u5468|\u4e0a\u5468|\u4e0a\u4e0a\u5468|\u4e0b\u5468|\u4e0b\u4e0b\u5468)");
    public static final Pattern SPECIFIC_YEAR_WEEK_PATTERN = Pattern.compile("(\\d{4})\u5e74\u7b2c(\\d{2})\u5468");
    public static final Pattern SPECIFIC_YEAR_MONTH_WEEK_PATTERN = Pattern.compile("(\\d{4})\u5e74(\\d{2})\u6708\u7b2c(\\d)\u5468");
    public static final Pattern GENERAL_YEAR_WEEK_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)\u7b2c(\\d{2})\u5468");
    public static final Pattern GENERAL_MONTH_WEEK_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708)\u7b2c(\\d)\u5468");
    public static final Pattern GENERAL_YEAR_MONTH_WEEK_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)(\\d{2})\u6708\u7b2c(\\d)\u5468");
    public static final Pattern SPECIFIC_YEAR_MONTH_LAST_WEEK_PATTERN = Pattern.compile("(\\d{4})\u5e74(\\d{2})\u6708\u6700\u540e\u4e00\u5468");
    public static final Pattern GENERAL_MONTH_LAST_WEEK_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708|\u4e0a\u4e0a\u6708)\u6700\u540e\u4e00\u5468");
    public static final Pattern SPECIFIC_YEAR_MONTH_COMPLETE_WEEK_PATTERN = Pattern.compile("(\\d{4})\u5e74(\\d{2})\u6708\u7b2c(\\d)\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern GENERAL_YEAR_COMPLETE_WEEK_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)\u7b2c(\\d{2})\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern SPECIFIC_YEAR_COMPLETE_WEEK_PATTERN = Pattern.compile("(\\d{4})\u5e74\u7b2c(\\d{2})\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern GENERAL_YEAR_MONTH_COMPLETE_WEEK_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)(\\d{2})\u6708\u7b2c(\\d)\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern GENERAL_MONTH_COMPLETE_WEEK_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708)\u7b2c(\\d)\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern GENERAL_MONTH_LAST_COMPLETE_WEEK_PATTERN = Pattern.compile("(\u672c\u6708|\u4e0a\u6708|\u4e0a\u4e0a\u6708)\u6700\u540e\u4e00\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern RECENT_N_YEAR_PATTERN = Pattern.compile("\u8fd1(\\d+)\u5e74");
    public static final Pattern RECENT_N_MONTH_PATTERN = Pattern.compile("\u8fd1(\\d+)\u4e2a\u6708");
    public static final Pattern RECENT_N_WEEK_PATTERN = Pattern.compile("\u8fd1(\\d+)\u5468");
    public static final Pattern RECENT_N_DAY_PATTERN = Pattern.compile("\u8fd1(\\d+)\u5929");
    public static final Pattern RECENT_N_COMPLETE_YEAR_PATTERN = Pattern.compile("\u8fd1(\\d+)\u4e2a\u5b8c\u6574\u5e74");
    public static final Pattern RECENT_N_COMPLETE_QUARTER_PATTERN = Pattern.compile("\u8fd1(\\d+)\u4e2a\u5b8c\u6574\u5b63\u5ea6");
    public static final Pattern RECENT_N_COMPLETE_MONTH_PATTERN = Pattern.compile("\u8fd1(\\d+)\u4e2a\u5b8c\u6574\u6708");
    public static final Pattern RECENT_N_COMPLETE_WEEK_PATTERN = Pattern.compile("\u8fd1(\\d+)\u4e2a\u5b8c\u6574\u5468");
    public static final Pattern RECENT_N_DAY_WITHOUT_TODAY_PATTERN = Pattern.compile("\u4e0d\u5305\u542b\u4eca\u5929\u7684\u8fd1(\\d+)\u5929");
    public static final Pattern RECENT_N_QUARTER_WITH_CURRENT_PATTERN = Pattern.compile("\u5305\u542b\u5f53\u524d\u5b63\u5ea6\u7684\u8fd1(\\d+)\u4e2a\u5b63\u5ea6");
    public static final Pattern SPECIFIC_YEAR_HALF_YEAR_PATTERN = Pattern.compile("(\\d{4})\u5e74(\u4e0a|\u4e0b)\u534a\u5e74");
    public static final Pattern GENERAL_YEAR_HALF_YEAR_PATTERN = Pattern.compile("(\u4eca\u5e74|\u53bb\u5e74|\u524d\u5e74|\u660e\u5e74|\u540e\u5e74)(\u4e0a|\u4e0b)\u534a\u5e74");
    public static final Pattern HALF_YEAR_PATTERN = Pattern.compile("(\u4e0a|\u4e0b)\u534a\u5e74");

    public static String buildDateTimeComment(List<String> expressions) {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        int quarter = now.get(IsoFields.QUARTER_OF_YEAR);
        String todayComment = String.format("\u4eca\u5929\u662f%d\u5e74%02d\u6708%02d\u65e5\uff0c\u662f%d\u5e74\u7684\u7b2c%d\u5b63\u5ea6", year, month, day, year, quarter);
        List<String> dateTimeCommentList = DateTimeUtil.buildDateExpressions(expressions, now);
        StringBuilder finalExpression = new StringBuilder();
        finalExpression.append(todayComment).append("\n");
        finalExpression.append("\u9700\u8981\u8ba1\u7b97\u7684\u65f6\u95f4\u662f\uff1a\n");
        dateTimeCommentList.forEach(comment -> finalExpression.append((String)comment).append("\n"));
        return finalExpression.toString();
    }

    public static List<String> buildDateExpressions(List<String> expressions, LocalDate now) {
        ArrayList<String> dateTimeCommentList = new ArrayList<String>();
        for (String expression : expressions) {
            String comment;
            String halfYearEx;
            String comment2;
            Object comment3;
            String quarterEx;
            String monthEx;
            Matcher specificYearMonthDayMatcher = SPECIFIC_YEAR_MONTH_DAY_PATTERN.matcher(expression);
            if (specificYearMonthDayMatcher.matches()) {
                dateTimeCommentList.add(expression + "=" + expression);
                continue;
            }
            Matcher generalYearMonthDayMatcher = GENERAL_YEAR_MONTH_DAY_PATTERN.matcher(expression);
            if (generalYearMonthDayMatcher.matches()) {
                String yearEx = generalYearMonthDayMatcher.group(1);
                String comment4 = DateTimeUtil.getYearEx(now, yearEx, false) + generalYearMonthDayMatcher.group(2);
                dateTimeCommentList.add(expression + "=" + comment4);
                continue;
            }
            Matcher generalMonthDayMatcher = GENERAL_MONTH_DAY_PATTERN.matcher(expression);
            if (generalMonthDayMatcher.matches()) {
                String monthEx2 = generalMonthDayMatcher.group(1);
                String comment5 = DateTimeUtil.getMonthEx(now, monthEx2) + generalMonthDayMatcher.group(2);
                dateTimeCommentList.add(expression + "=" + comment5);
                continue;
            }
            Matcher yearMonthLastDayMatcher = GENERAL_YEAR_MONTH_LAST_DAY_PATTERN.matcher(expression);
            if (yearMonthLastDayMatcher.matches()) {
                String yearEx = yearMonthLastDayMatcher.group(1);
                monthEx = yearMonthLastDayMatcher.group(2);
                String comment6 = DateTimeUtil.getGeneralYearMonthLastDayEx(now, yearEx, Integer.valueOf(monthEx));
                dateTimeCommentList.add(expression + "=" + comment6);
                continue;
            }
            Matcher monthLastDayMatcher = GENERAL_MONTH_LAST_DAY_PATTERN.matcher(expression);
            if (monthLastDayMatcher.matches()) {
                monthEx = monthLastDayMatcher.group(1);
                String comment7 = DateTimeUtil.getMonthLastDayEx(now, monthEx);
                dateTimeCommentList.add(expression + "=" + comment7);
                continue;
            }
            Matcher weekDayMatcher = WEEK_DAY_PATTERN.matcher(expression);
            if (weekDayMatcher.matches()) {
                int weekDay = Integer.parseInt(weekDayMatcher.group(1));
                String comment8 = DateTimeUtil.getWeekDayEx(now, weekDay);
                dateTimeCommentList.add(expression + "=" + comment8);
                continue;
            }
            Matcher generalWeekDayMatcher = GENERAL_WEEK_SPECIFIC_DAY_PATTERN.matcher(expression);
            if (generalWeekDayMatcher.matches()) {
                String weekEx = generalWeekDayMatcher.group(1);
                int day = Integer.parseInt(generalWeekDayMatcher.group(2));
                String comment9 = DateTimeUtil.getGeneralWeekDayEx(now, weekEx, day);
                dateTimeCommentList.add(expression + "=" + comment9);
                continue;
            }
            Matcher specificYearQuarterMatcher = SPECIFIC_YEAR_QUARTER_PATTERN.matcher(expression);
            if (specificYearQuarterMatcher.matches()) {
                dateTimeCommentList.add(expression + "=" + expression);
                continue;
            }
            Matcher generalYearQuarterMatcher = GENERAL_YEAR_QUARTER_PATTERN.matcher(expression);
            if (generalYearQuarterMatcher.matches()) {
                String yearEx = generalYearQuarterMatcher.group(1);
                quarterEx = generalYearQuarterMatcher.group(2);
                comment3 = DateTimeUtil.getYearEx(now, yearEx, false) + quarterEx;
                dateTimeCommentList.add(expression + "=" + (String)comment3);
                continue;
            }
            Matcher generalQuarterMatcher = GENERAL_QUARTER_PATTERN.matcher(expression);
            if (generalQuarterMatcher.matches()) {
                quarterEx = generalQuarterMatcher.group(1);
                comment3 = DateTimeUtil.getQuarterEx(now, quarterEx);
                dateTimeCommentList.add(expression + "=" + (String)comment3);
                continue;
            }
            Matcher generalWeekMatcher = GENERAL_WEEK_PATTERN.matcher(expression);
            if (generalWeekMatcher.matches()) {
                String weekEx = generalWeekMatcher.group(1);
                String comment10 = DateTimeUtil.getWeekEx(now, weekEx);
                dateTimeCommentList.add(expression + "=" + comment10);
                continue;
            }
            Matcher specificYearWeekMatcher = SPECIFIC_YEAR_WEEK_PATTERN.matcher(expression);
            if (specificYearWeekMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearWeekMatcher.group(1));
                int weekEx = Integer.parseInt(specificYearWeekMatcher.group(2));
                String comment11 = DateTimeUtil.getSpecificYearWeekEx(now, yearEx, weekEx);
                dateTimeCommentList.add(expression + "=" + comment11);
                continue;
            }
            Matcher generalYearWeekMatcher = GENERAL_YEAR_WEEK_PATTERN.matcher(expression);
            if (generalYearWeekMatcher.matches()) {
                String yearEx = generalYearWeekMatcher.group(1);
                int weekEx = Integer.parseInt(generalYearWeekMatcher.group(2));
                String comment12 = DateTimeUtil.getGeneralYearWeekEx(now, yearEx, weekEx);
                dateTimeCommentList.add(expression + "=" + comment12);
                continue;
            }
            Matcher generalMonthWeekMatcher = GENERAL_MONTH_WEEK_PATTERN.matcher(expression);
            if (generalMonthWeekMatcher.matches()) {
                String monthEx3 = generalMonthWeekMatcher.group(1);
                int weekEx = Integer.parseInt(generalMonthWeekMatcher.group(2));
                String comment13 = DateTimeUtil.getGeneralMonthWeekEx(now, monthEx3, weekEx);
                dateTimeCommentList.add(expression + "=" + comment13);
                continue;
            }
            Matcher specificYearMonthLastWeekMatcher = SPECIFIC_YEAR_MONTH_LAST_WEEK_PATTERN.matcher(expression);
            if (specificYearMonthLastWeekMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearMonthLastWeekMatcher.group(1));
                int monthEx4 = Integer.parseInt(specificYearMonthLastWeekMatcher.group(2));
                comment2 = DateTimeUtil.getSpecificYearMonthLastWeek(now, yearEx, monthEx4);
                dateTimeCommentList.add(expression + "=" + comment2);
                continue;
            }
            Matcher generalMonthLastWeekMatcher = GENERAL_MONTH_LAST_WEEK_PATTERN.matcher(expression);
            if (generalMonthLastWeekMatcher.matches()) {
                String monthEx5 = generalMonthLastWeekMatcher.group(1);
                comment2 = DateTimeUtil.getGeneralMonthLastWeek(now, monthEx5);
                dateTimeCommentList.add(expression + "=" + comment2);
                continue;
            }
            Matcher generalMonthLastCompleteWeekMatcher = GENERAL_MONTH_LAST_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (generalMonthLastCompleteWeekMatcher.matches()) {
                String monthEx6 = generalMonthLastCompleteWeekMatcher.group(1);
                String comment14 = DateTimeUtil.getGeneralMonthLastCompleteWeekEx(now, monthEx6);
                dateTimeCommentList.add(expression + "=" + comment14);
                continue;
            }
            Matcher recentNYearMatcher = RECENT_N_YEAR_PATTERN.matcher(expression);
            if (recentNYearMatcher.matches()) {
                int n = Integer.parseInt(recentNYearMatcher.group(1));
                String comment15 = DateTimeUtil.getRecentNYear(now, n);
                dateTimeCommentList.add(expression + "=" + comment15);
                continue;
            }
            Matcher recentNMonthMatcher = RECENT_N_MONTH_PATTERN.matcher(expression);
            if (recentNMonthMatcher.matches()) {
                int n = Integer.parseInt(recentNMonthMatcher.group(1));
                String comment16 = DateTimeUtil.getRecentNMonth(now, n);
                dateTimeCommentList.add(expression + "=" + comment16);
                continue;
            }
            Matcher recentNWeekMatcher = RECENT_N_WEEK_PATTERN.matcher(expression);
            if (recentNWeekMatcher.matches()) {
                int n = Integer.parseInt(recentNWeekMatcher.group(1));
                String comment17 = DateTimeUtil.getRecentNWeek(now, n);
                dateTimeCommentList.add(expression + "=" + comment17);
                continue;
            }
            Matcher recentNDayWithoutTodayMatcher = RECENT_N_DAY_WITHOUT_TODAY_PATTERN.matcher(expression);
            if (recentNDayWithoutTodayMatcher.matches()) {
                int n = Integer.parseInt(recentNDayWithoutTodayMatcher.group(1));
                String comment18 = DateTimeUtil.getRecentNDayWithoutToday(now, n);
                dateTimeCommentList.add(expression + "=" + comment18);
                continue;
            }
            Matcher recentNDayMatcher = RECENT_N_DAY_PATTERN.matcher(expression);
            if (recentNDayMatcher.matches()) {
                int n = Integer.parseInt(recentNDayMatcher.group(1));
                String comment19 = DateTimeUtil.getRecentNDay(now, n);
                dateTimeCommentList.add(expression + "=" + comment19);
                continue;
            }
            Matcher recentNCompleteYearMatcher = RECENT_N_COMPLETE_YEAR_PATTERN.matcher(expression);
            if (recentNCompleteYearMatcher.matches()) {
                int n = Integer.parseInt(recentNCompleteYearMatcher.group(1));
                String comment20 = DateTimeUtil.getRecentNCompleteYear(now, n);
                dateTimeCommentList.add(expression + "=" + comment20);
                continue;
            }
            Matcher recentNCompleteQuarterMatcher = RECENT_N_COMPLETE_QUARTER_PATTERN.matcher(expression);
            if (recentNCompleteQuarterMatcher.matches()) {
                int n = Integer.parseInt(recentNCompleteQuarterMatcher.group(1));
                String comment21 = DateTimeUtil.getRecentNCompleteQuarter(now, n);
                dateTimeCommentList.add(expression + "=" + comment21);
                continue;
            }
            Matcher recentNCompleteMonthMatcher = RECENT_N_COMPLETE_MONTH_PATTERN.matcher(expression);
            if (recentNCompleteMonthMatcher.matches()) {
                int n = Integer.parseInt(recentNCompleteMonthMatcher.group(1));
                String comment22 = DateTimeUtil.getRecentNCompleteMonth(now, n);
                dateTimeCommentList.add(expression + "=" + comment22);
                continue;
            }
            Matcher recentNCompleteWeekMatcher = RECENT_N_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (recentNCompleteWeekMatcher.matches()) {
                int n = Integer.parseInt(recentNCompleteWeekMatcher.group(1));
                String comment23 = DateTimeUtil.getRecentNCompleteWeek(now, n);
                dateTimeCommentList.add(expression + "=" + comment23);
                continue;
            }
            Matcher recentNQuarterWithCurrentMatcher = RECENT_N_QUARTER_WITH_CURRENT_PATTERN.matcher(expression);
            if (recentNQuarterWithCurrentMatcher.matches()) {
                int n = Integer.parseInt(recentNQuarterWithCurrentMatcher.group(1));
                String comment24 = DateTimeUtil.getRecentNQuarterWithCurrent(now, n);
                dateTimeCommentList.add(expression + "=" + comment24);
                continue;
            }
            Matcher specificYearMonthMatcher = SPECIFIC_YEAR_MONTH_PATTERN.matcher(expression);
            if (specificYearMonthMatcher.matches()) {
                dateTimeCommentList.add(expression + "=" + expression);
                continue;
            }
            Matcher generalYearMonthMatcher = GENERAL_YEAR_MONTH_PATTERN.matcher(expression);
            if (generalYearMonthMatcher.matches()) {
                String yearEx = generalYearMonthMatcher.group(1);
                String comment25 = DateTimeUtil.getYearEx(now, yearEx, false) + generalYearMonthMatcher.group(2);
                dateTimeCommentList.add(expression + "=" + comment25);
                continue;
            }
            Matcher generalDayMatcher = GENERAL_DAY_PATTERN.matcher(expression);
            if (generalDayMatcher.matches()) {
                String dayEx = generalDayMatcher.group(1);
                String comment26 = DateTimeUtil.getDayEx(now, dayEx);
                dateTimeCommentList.add(expression + "=" + comment26);
                continue;
            }
            Matcher generalMonthMatcher = GENERAL_MONTH_PATTERN.matcher(expression);
            if (generalMonthMatcher.matches()) {
                String monthEx7 = generalMonthMatcher.group(1);
                String comment27 = DateTimeUtil.getMonthEx(now, monthEx7);
                dateTimeCommentList.add(expression + "=" + comment27);
                continue;
            }
            Matcher specificYearMatcher = SPECIFIC_YEAR_PATTERN.matcher(expression);
            if (specificYearMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearMatcher.group(1));
                String comment28 = String.valueOf(yearEx) + "\u5e74";
                dateTimeCommentList.add(expression + "=" + comment28);
                continue;
            }
            Matcher generalYearMatcher = GENERAL_YEAR_PATTERN.matcher(expression);
            if (generalYearMatcher.matches()) {
                String yearEx = generalYearMatcher.group(1);
                String comment29 = DateTimeUtil.getYearEx(now, yearEx, true);
                dateTimeCommentList.add(expression + "=" + comment29);
                continue;
            }
            Matcher specificYearMonthWeekMatcher = SPECIFIC_YEAR_MONTH_WEEK_PATTERN.matcher(expression);
            if (specificYearMonthWeekMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearMonthWeekMatcher.group(1));
                int monthEx8 = Integer.parseInt(specificYearMonthWeekMatcher.group(2));
                int weekEx = Integer.parseInt(specificYearMonthWeekMatcher.group(3));
                String comment30 = DateTimeUtil.getSpecificYearMonthWeekEx(now, yearEx, monthEx8, weekEx);
                dateTimeCommentList.add(expression + "=" + comment30);
                continue;
            }
            Matcher generalYearMonthWeekMatcher = GENERAL_YEAR_MONTH_WEEK_PATTERN.matcher(expression);
            if (generalYearMonthWeekMatcher.matches()) {
                String yearEx = generalYearMonthWeekMatcher.group(1);
                int monthEx9 = Integer.parseInt(generalYearMonthWeekMatcher.group(2));
                int weekEx = Integer.parseInt(generalYearMonthWeekMatcher.group(3));
                String comment31 = DateTimeUtil.getGeneralYearMonthWeekEx(now, yearEx, monthEx9, weekEx);
                dateTimeCommentList.add(expression + "=" + comment31);
                continue;
            }
            Matcher specificYearMonthCompleteWeekMatcher = SPECIFIC_YEAR_MONTH_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (specificYearMonthCompleteWeekMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearMonthCompleteWeekMatcher.group(1));
                int monthEx10 = Integer.parseInt(specificYearMonthCompleteWeekMatcher.group(2));
                int weekEx = Integer.parseInt(specificYearMonthCompleteWeekMatcher.group(3));
                String comment32 = DateTimeUtil.getSpecificYearMonthCompleteWeekEx(now, yearEx, monthEx10, weekEx);
                dateTimeCommentList.add(expression + "=" + comment32);
                continue;
            }
            Matcher generalYearMonthCompleteWeekMatcher = GENERAL_YEAR_MONTH_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (generalYearMonthCompleteWeekMatcher.matches()) {
                String yearEx = generalYearMonthCompleteWeekMatcher.group(1);
                int monthEx11 = Integer.parseInt(generalYearMonthCompleteWeekMatcher.group(2));
                int weekEx = Integer.parseInt(generalYearMonthCompleteWeekMatcher.group(3));
                String comment33 = DateTimeUtil.getGeneralYearMonthCompleteWeekEx(now, yearEx, monthEx11, weekEx);
                dateTimeCommentList.add(expression + "=" + comment33);
                continue;
            }
            Matcher generalMonthCompleteWeekMatcher = GENERAL_MONTH_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (generalMonthCompleteWeekMatcher.matches()) {
                String monthEx12 = generalMonthCompleteWeekMatcher.group(1);
                int weekEx = Integer.parseInt(generalMonthCompleteWeekMatcher.group(2));
                String comment34 = DateTimeUtil.getGeneralMonthCompleteWeekEx(now, monthEx12, weekEx);
                dateTimeCommentList.add(expression + "=" + comment34);
                continue;
            }
            Matcher specificYearCompleteWeekMatcher = SPECIFIC_YEAR_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (specificYearCompleteWeekMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearCompleteWeekMatcher.group(1));
                int weekEx = Integer.parseInt(specificYearCompleteWeekMatcher.group(2));
                String comment35 = DateTimeUtil.getSpecificYearCompleteWeekEx(now, yearEx, weekEx);
                dateTimeCommentList.add(expression + "=" + comment35);
                continue;
            }
            Matcher generalYearCompleteWeekMatcher = GENERAL_YEAR_COMPLETE_WEEK_PATTERN.matcher(expression);
            if (generalYearCompleteWeekMatcher.matches()) {
                String yearEx = generalYearCompleteWeekMatcher.group(1);
                int weekEx = Integer.parseInt(generalYearCompleteWeekMatcher.group(2));
                String comment36 = DateTimeUtil.getGeneralYearCompleteWeekEx(now, yearEx, weekEx);
                dateTimeCommentList.add(expression + "=" + comment36);
                continue;
            }
            Matcher specificYearHalfYearMatcher = SPECIFIC_YEAR_HALF_YEAR_PATTERN.matcher(expression);
            if (specificYearHalfYearMatcher.matches()) {
                int yearEx = Integer.parseInt(specificYearHalfYearMatcher.group(1));
                String halfYearEx2 = specificYearHalfYearMatcher.group(2);
                String comment37 = DateTimeUtil.getSpecificYearHalfYearEx(now, yearEx, halfYearEx2);
                dateTimeCommentList.add(expression + "=" + comment37);
                continue;
            }
            Matcher generalYearHalfYearMatcher = GENERAL_YEAR_HALF_YEAR_PATTERN.matcher(expression);
            if (generalYearHalfYearMatcher.matches()) {
                String yearEx = generalYearHalfYearMatcher.group(1);
                halfYearEx = generalYearHalfYearMatcher.group(2);
                comment = DateTimeUtil.getGeneralYearHalfYearEx(now, yearEx, halfYearEx);
                dateTimeCommentList.add(expression + "=" + comment);
                continue;
            }
            Matcher halfYearMatcher = HALF_YEAR_PATTERN.matcher(expression);
            if (!halfYearMatcher.matches()) continue;
            halfYearEx = halfYearMatcher.group(1);
            comment = DateTimeUtil.getSpecificYearHalfYearEx(now, now.getYear(), halfYearEx);
            dateTimeCommentList.add(expression + "=" + comment);
        }
        return dateTimeCommentList;
    }

    public static String getYearEx(LocalDate now, String yearEx, boolean applyDomainLogic) {
        Object comment = "";
        int year = 0;
        if (yearEx.equals("\u4eca\u5e74")) {
            year = now.getYear();
        } else if (yearEx.equals("\u53bb\u5e74")) {
            year = now.getYear() - 1;
        } else if (yearEx.equals("\u524d\u5e74")) {
            year = now.getYear() - 2;
        } else if (yearEx.equals("\u660e\u5e74")) {
            year = now.getYear() + 1;
        } else if (yearEx.equals("\u540e\u5e74")) {
            year = now.getYear() + 2;
        }
        comment = String.valueOf(year) + "\u5e74";
        return comment;
    }

    public static String getMonthEx(LocalDate now, String monthEx) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708");
        String comment = "";
        if (monthEx.equals("\u672c\u6708")) {
            comment = formatter.format(YearMonth.from(now));
        } else if (monthEx.equals("\u4e0a\u6708")) {
            comment = formatter.format(YearMonth.from(now).minusMonths(1L));
        } else if (monthEx.equals("\u4e0a\u4e0a\u6708")) {
            comment = formatter.format(YearMonth.from(now).minusMonths(2L));
        } else if (monthEx.equals("\u4e0b\u6708")) {
            comment = formatter.format(YearMonth.from(now).plusMonths(1L));
        } else if (monthEx.equals("\u53bb\u5e74\u672c\u6708")) {
            comment = formatter.format(YearMonth.from(now).minusYears(1L));
        }
        return comment;
    }

    public static String getDayEx(LocalDate now, String dayEx) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        String comment = "";
        try {
            if (dayEx.equals("\u4eca\u5929")) {
                comment = formatter.format(now);
            } else if (dayEx.equals("\u6628\u5929")) {
                comment = formatter.format(now.minusDays(1L));
            } else if (dayEx.equals("\u524d\u5929")) {
                comment = formatter.format(now.minusDays(2L));
            } else if (dayEx.equals("\u660e\u5929")) {
                comment = formatter.format(now.plusDays(1L));
            } else if (dayEx.equals("\u540e\u5929")) {
                comment = formatter.format(now.plusDays(2L));
            } else if (dayEx.equals("\u4e0a\u6708\u4eca\u5929")) {
                comment = formatter.format(YearMonth.from(now).minusMonths(1L).atDay(now.getDayOfMonth()));
            } else if (dayEx.equals("\u4e0a\u4e0a\u6708\u4eca\u5929")) {
                comment = formatter.format(YearMonth.from(now).minusMonths(2L).atDay(now.getDayOfMonth()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comment;
    }

    public static final String getWeekDayEx(LocalDate now, int x) {
        LocalDate monday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate desiredDay = monday.plusDays(x - 1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(desiredDay);
    }

    public static final String getGeneralWeekDayEx(LocalDate now, String weekEx, int day) {
        LocalDate thisMonday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate desiredDay = thisMonday.plusDays(day - 1);
        if (!weekEx.equals("\u672c\u5468")) {
            if (weekEx.equals("\u4e0a\u5468")) {
                desiredDay = desiredDay.minusWeeks(1L);
            } else if (weekEx.equals("\u4e0a\u4e0a\u5468")) {
                desiredDay = desiredDay.minusWeeks(2L);
            } else if (weekEx.equals("\u4e0b\u5468")) {
                desiredDay = desiredDay.plusWeeks(1L);
            } else if (weekEx.equals("\u4e0b\u4e0b\u5468")) {
                desiredDay = desiredDay.plusWeeks(2L);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(desiredDay);
    }

    public static final String getWeekEx(LocalDate now, String weekEx) {
        LocalDate desireMonday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate desireSunday = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        if (!weekEx.equals("\u672c\u5468")) {
            if (weekEx.equals("\u4e0a\u5468")) {
                desireMonday = desireMonday.minusWeeks(1L);
                desireSunday = desireSunday.minusWeeks(1L);
            } else if (weekEx.equals("\u4e0a\u4e0a\u5468")) {
                desireMonday = desireMonday.minusWeeks(2L);
                desireSunday = desireSunday.minusWeeks(2L);
            } else if (weekEx.equals("\u4e0b\u5468")) {
                desireMonday = desireMonday.plusWeeks(1L);
                desireSunday = desireSunday.plusWeeks(1L);
            } else if (weekEx.equals("\u4e0b\u4e0b\u5468")) {
                desireMonday = desireMonday.plusWeeks(2L);
                desireSunday = desireSunday.plusWeeks(2L);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(desireMonday) + "\u81f3" + formatter.format(desireSunday);
    }

    public static String getSpecificYearWeekEx(LocalDate now, int year, int week) {
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        LocalDate targetWeekFirstDay = firstDayOfYear.plusWeeks(week - 1);
        LocalDate targetWeekLastDay = targetWeekFirstDay.plusDays(6L);
        LocalDate lastDayOfYear = firstDayOfYear.with(TemporalAdjusters.lastDayOfYear());
        if (lastDayOfYear.isBefore(targetWeekLastDay)) {
            targetWeekLastDay = lastDayOfYear;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(targetWeekFirstDay) + "\u81f3" + formatter.format(targetWeekLastDay);
    }

    public static String getGeneralYearWeekEx(LocalDate now, String yearEx, int week) {
        int year = now.getYear();
        if (!yearEx.equals("\u4eca\u5e74")) {
            if (yearEx.equals("\u53bb\u5e74")) {
                year = now.getYear() - 1;
            } else if (yearEx.equals("\u524d\u5e74")) {
                year = now.getYear() - 2;
            } else if (yearEx.equals("\u660e\u5e74")) {
                year = now.getYear() + 1;
            } else if (yearEx.equals("\u540e\u5e74")) {
                year = now.getYear() + 2;
            }
        }
        return DateTimeUtil.getSpecificYearWeekEx(now, year, week);
    }

    public static String getSpecificYearMonthWeekEx(LocalDate now, int year, int month, int week) {
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate targetWeekFirstDay = firstDayOfMonth.plusWeeks(week - 1);
        LocalDate targetWeekLastDay = targetWeekFirstDay.plusDays(6L);
        LocalDate lastDayOfMonth = firstDayOfMonth.with(TemporalAdjusters.lastDayOfMonth());
        if (lastDayOfMonth.isBefore(targetWeekLastDay)) {
            targetWeekLastDay = lastDayOfMonth;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(targetWeekFirstDay) + "\u81f3" + formatter.format(targetWeekLastDay);
    }

    public static String getGeneralYearMonthWeekEx(LocalDate now, String yearEx, int month, int week) {
        int year = now.getYear();
        if (!yearEx.equals("\u4eca\u5e74")) {
            if (yearEx.equals("\u53bb\u5e74")) {
                year = now.getYear() - 1;
            } else if (yearEx.equals("\u524d\u5e74")) {
                year = now.getYear() - 2;
            } else if (yearEx.equals("\u660e\u5e74")) {
                year = now.getYear() + 1;
            } else if (yearEx.equals("\u540e\u5e74")) {
                year = now.getYear() + 2;
            }
        }
        return DateTimeUtil.getSpecificYearMonthWeekEx(now, year, month, week);
    }

    public static String getGeneralMonthWeekEx(LocalDate now, String monthEx, int week) {
        int year = now.getYear();
        int month = now.getMonthValue();
        if (!monthEx.equals("\u672c\u6708") && monthEx.equals("\u4e0a\u6708") && (month = now.getMonthValue() - 1) <= 0) {
            --year;
            month = 12 + month;
        }
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate targetWeekFirstDay = firstDayOfMonth.plusWeeks(week - 1);
        LocalDate targetWeekLastDay = targetWeekFirstDay.plusDays(6L);
        LocalDate lastDayOfMonth = firstDayOfMonth.with(TemporalAdjusters.lastDayOfMonth());
        if (lastDayOfMonth.isBefore(targetWeekLastDay)) {
            targetWeekLastDay = lastDayOfMonth;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(targetWeekFirstDay) + "\u81f3" + formatter.format(targetWeekLastDay);
    }

    public static String getSpecificYearMonthCompleteWeekEx(LocalDate now, int year, int month, int week) {
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate firstMonday = firstDayOfMonth.with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY));
        LocalDate targetStartDate = firstMonday.plusWeeks(week - 1);
        LocalDate targetEndDate = targetStartDate.plusDays(6L);
        LocalDate lastDayOfMonth = firstDayOfMonth.with(TemporalAdjusters.lastDayOfMonth());
        if (lastDayOfMonth.isBefore(targetEndDate)) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(targetStartDate) + "\u81f3" + formatter.format(targetEndDate);
    }

    public static String getGeneralYearMonthCompleteWeekEx(LocalDate now, String yearEx, int month, int week) {
        int year = now.getYear();
        if (!yearEx.equals("\u4eca\u5e74")) {
            if (yearEx.equals("\u53bb\u5e74")) {
                year = now.getYear() - 1;
            } else if (yearEx.equals("\u524d\u5e74")) {
                year = now.getYear() - 2;
            } else if (yearEx.equals("\u660e\u5e74")) {
                year = now.getYear() + 1;
            } else if (yearEx.equals("\u540e\u5e74")) {
                year = now.getYear() + 2;
            }
        }
        return DateTimeUtil.getSpecificYearMonthCompleteWeekEx(now, year, month, week);
    }

    public static String getGeneralMonthCompleteWeekEx(LocalDate now, String monthEx, int week) {
        int year = now.getYear();
        int month = now.getMonthValue();
        if (!monthEx.equals("\u672c\u6708")) {
            if (monthEx.equals("\u4e0a\u6708")) {
                month = now.getMonthValue() - 1;
                if (month <= 0) {
                    --year;
                    month = 12 + month;
                }
            } else if (monthEx.equals("\u4e0a\u4e0a\u6708")) {
                month = now.getMonthValue() - 2;
                if (month <= 0) {
                    --year;
                    month = 12 + month;
                }
            } else if (monthEx.equals("\u4e0b\u6708") && (month = now.getMonthValue() + 1) > 12) {
                ++year;
                month -= 12;
            }
        }
        return DateTimeUtil.getSpecificYearMonthCompleteWeekEx(now, year, month, week);
    }

    public static String getSpecificYearCompleteWeekEx(LocalDate now, int year, int week) {
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        LocalDate firstMonday = firstDayOfYear.with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY));
        LocalDate targetStartDate = firstMonday.plusWeeks(week - 1);
        LocalDate targetEndDate = targetStartDate.plusDays(6L);
        LocalDate lastDayOfYear = firstDayOfYear.with(TemporalAdjusters.lastDayOfYear());
        if (lastDayOfYear.isBefore(targetEndDate)) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(targetStartDate) + "\u81f3" + formatter.format(targetEndDate);
    }

    public static String getGeneralYearCompleteWeekEx(LocalDate now, String yearEx, int week) {
        int year = now.getYear();
        if (!yearEx.equals("\u4eca\u5e74")) {
            if (yearEx.equals("\u53bb\u5e74")) {
                year = now.getYear() - 1;
            } else if (yearEx.equals("\u524d\u5e74")) {
                year = now.getYear() - 2;
            } else if (yearEx.equals("\u660e\u5e74")) {
                year = now.getYear() + 1;
            } else if (yearEx.equals("\u540e\u5e74")) {
                year = now.getYear() + 2;
            }
        }
        return DateTimeUtil.getSpecificYearCompleteWeekEx(now, year, week);
    }

    public static String getSpecificYearMonthLastWeek(LocalDate now, int year, int month) {
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate lastDayOfMonth = firstDayOfMonth.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate previousMonday = lastDayOfMonth.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(previousMonday) + "\u81f3" + formatter.format(lastDayOfMonth);
    }

    public static String getGeneralMonthLastWeek(LocalDate now, String monthEx) {
        int year = now.getYear();
        int month = now.getMonthValue();
        if (!monthEx.equals("\u672c\u6708")) {
            if (monthEx.equals("\u4e0a\u6708")) {
                month = now.getMonthValue() - 1;
                if (month <= 0) {
                    --year;
                    month = 12 + month;
                }
            } else if (monthEx.equals("\u4e0a\u4e0a\u6708")) {
                month = now.getMonthValue() - 2;
                if (month <= 0) {
                    --year;
                    month = 12 + month;
                }
            } else if (monthEx.equals("\u4e0b\u6708") && (month = now.getMonthValue() + 1) > 12) {
                ++year;
                month -= 12;
            }
        }
        return DateTimeUtil.getSpecificYearMonthLastWeek(now, year, month);
    }

    public static String getSpecificYearMonthLastCompleteWeekEx(LocalDate now, int year, int month) {
        LocalDate firstDayOfMonth = LocalDate.of(year, month, 1);
        LocalDate lastSunday = firstDayOfMonth.with(TemporalAdjusters.lastInMonth(DayOfWeek.SUNDAY));
        LocalDate lastMonday = lastSunday.minusDays(6L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(lastMonday) + "\u81f3" + formatter.format(lastSunday);
    }

    public static String getGeneralMonthLastCompleteWeekEx(LocalDate now, String monthEx) {
        int year = now.getYear();
        int month = now.getMonthValue();
        if (!monthEx.equals("\u672c\u6708")) {
            if (monthEx.equals("\u4e0a\u6708")) {
                month = now.getMonthValue() - 1;
                if (month <= 0) {
                    --year;
                    month = 12 + month;
                }
            } else if (monthEx.equals("\u4e0a\u4e0a\u6708")) {
                month = now.getMonthValue() - 2;
                if (month <= 0) {
                    --year;
                    month = 12 + month;
                }
            } else if (monthEx.equals("\u4e0b\u6708") && (month = now.getMonthValue() + 1) > 12) {
                ++year;
                month -= 12;
            }
        }
        return DateTimeUtil.getSpecificYearMonthLastCompleteWeekEx(now, year, month);
    }

    public static String getQuarterEx(LocalDate now, String quarterEx) {
        int currentQuarter = now.get(IsoFields.QUARTER_OF_YEAR);
        int lastQuarter = currentQuarter == 1 ? 4 : currentQuarter - 1;
        int nextQuarter = currentQuarter == 4 ? 1 : currentQuarter + 1;
        int currentYear = now.getYear();
        int yearOfLastQuarter = currentQuarter == 1 ? currentYear - 1 : currentYear;
        int yearOfNextQuarter = currentQuarter == 4 ? currentYear + 1 : currentYear;
        int yearOfSameQuarterLastYear = currentYear - 1;
        Object comment = "";
        if (quarterEx.equals("\u672c\u5b63\u5ea6")) {
            comment = currentYear + "\u5e74\u7b2c" + currentQuarter + "\u5b63\u5ea6";
        } else if (quarterEx.equals("\u4e0a\u5b63\u5ea6")) {
            comment = yearOfLastQuarter + "\u5e74\u7b2c" + lastQuarter + "\u5b63\u5ea6";
        } else if (quarterEx.equals("\u4e0b\u5b63\u5ea6")) {
            comment = yearOfNextQuarter + "\u5e74\u7b2c" + nextQuarter + "\u5b63\u5ea6";
        } else if (quarterEx.equals("\u53bb\u5e74\u672c\u5b63\u5ea6")) {
            comment = yearOfSameQuarterLastYear + "\u5e74\u7b2c" + currentQuarter + "\u5b63\u5ea6";
        }
        return comment;
    }

    public static String getRecentNYear(LocalDate now, int n) {
        LocalDate startDate = now.minusYears(n);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(now);
    }

    public static String getRecentNMonth(LocalDate now, int n) {
        LocalDate startDate = now.minusMonths(n);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(now);
    }

    public static String getRecentNWeek(LocalDate now, int n) {
        LocalDate startDate = now.minusWeeks(n);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(now);
    }

    public static String getRecentNDay(LocalDate now, int n) {
        LocalDate startDate = now.minusDays(n);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(now);
    }

    public static String getRecentNCompleteYear(LocalDate now, int n) {
        LocalDate endDate = now.getMonthValue() == 12 && now.getDayOfMonth() == 31 ? now : now.with(TemporalAdjusters.lastDayOfYear()).minusYears(1L);
        LocalDate startDate = endDate.minusYears(n).plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getRecentNCompleteMonth(LocalDate now, int n) {
        LocalDate endDate = now.equals(now.with(TemporalAdjusters.lastDayOfMonth())) ? now : now.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        LocalDate startDate = endDate.minusMonths(n).plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getRecentNCompleteQuarter(LocalDate now, int n) {
        int currentMonth = now.getMonthValue();
        LocalDate endDate = currentMonth % 4 == 0 && now.getDayOfMonth() == 31 ? now : (currentMonth < 4 ? LocalDate.of(now.getYear() - 1, 12, 31) : (currentMonth < 7 ? LocalDate.of(now.getYear(), 3, 31) : (currentMonth < 10 ? LocalDate.of(now.getYear(), 6, 30) : LocalDate.of(now.getYear(), 9, 30))));
        LocalDate startDate = endDate.minusMonths(n * 3).plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getRecentNCompleteWeek(LocalDate now, int n) {
        LocalDate endDate = now.getDayOfWeek().getValue() == 7 ? now : now.minusWeeks(1L).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        LocalDate startDate = endDate.minusWeeks(n).plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getRecentNDayWithoutToday(LocalDate now, int n) {
        LocalDate startDate = now.minusDays(n);
        LocalDate endDate = now.minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getRecentNQuarterWithCurrent(LocalDate now, int n) {
        int currentMonth = now.getMonthValue();
        LocalDate endDate = currentMonth < 4 ? LocalDate.of(now.getYear(), 3, 31) : (currentMonth < 7 ? LocalDate.of(now.getYear(), 6, 30) : (currentMonth < 10 ? LocalDate.of(now.getYear(), 9, 30) : LocalDate.of(now.getYear(), 12, 31)));
        LocalDate startDate = endDate.minusMonths(n * 3).plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getMonthLastDayEx(LocalDate now, String monthEx) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        String comment = "";
        if (monthEx.equals("\u672c\u6708")) {
            comment = formatter.format(YearMonth.from(now).atEndOfMonth());
        } else if (monthEx.equals("\u4e0a\u6708")) {
            comment = formatter.format(YearMonth.from(now).minusMonths(1L).atEndOfMonth());
        }
        return comment;
    }

    public static String getGeneralYearMonthLastDayEx(LocalDate now, String yearEx, int month) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        String comment = "";
        int year = 0;
        if (yearEx.equals("\u4eca\u5e74")) {
            year = now.getYear();
        } else if (yearEx.equals("\u53bb\u5e74")) {
            year = now.getYear() - 1;
        } else if (yearEx.equals("\u524d\u5e74")) {
            year = now.getYear() - 2;
        } else if (yearEx.equals("\u660e\u5e74")) {
            year = now.getYear() + 1;
        } else if (yearEx.equals("\u540e\u5e74")) {
            year = now.getYear() + 2;
        }
        comment = formatter.format(YearMonth.of(year, month).atEndOfMonth());
        return comment;
    }

    public static String getSpecificYearHalfYearEx(LocalDate now, int year, String halfYearEx) {
        LocalDate endDate;
        LocalDate startDate;
        if (halfYearEx.equals("\u4e0a")) {
            startDate = LocalDate.of(year, 1, 1);
            endDate = LocalDate.of(year, 6, 30);
        } else {
            startDate = LocalDate.of(year, 7, 1);
            endDate = LocalDate.of(year, 12, 31);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        return formatter.format(startDate) + "\u81f3" + formatter.format(endDate);
    }

    public static String getGeneralYearHalfYearEx(LocalDate now, String yearEx, String halfYearEx) {
        int year = 0;
        if (yearEx.equals("\u4eca\u5e74")) {
            year = now.getYear();
        } else if (yearEx.equals("\u53bb\u5e74")) {
            year = now.getYear() - 1;
        } else if (yearEx.equals("\u524d\u5e74")) {
            year = now.getYear() - 2;
        } else if (yearEx.equals("\u660e\u5e74")) {
            year = now.getYear() + 1;
        } else if (yearEx.equals("\u540e\u5e74")) {
            year = now.getYear() + 2;
        }
        return DateTimeUtil.getSpecificYearHalfYearEx(now, year, halfYearEx);
    }
}

