/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.util;

public class MarkdownParser {
    public static String extractText(String markdownCode) {
        String code = MarkdownParser.extractRawText(markdownCode);
        return code.replaceAll("\r\n", " ").replaceAll("\n", " ").replaceAll("\r", " ");
    }

    public static String extractRawText(String markdownCode) {
        String closingDelimiter;
        int endIndex;
        int contentStart;
        int startIndex = -1;
        int delimiterLength = 0;
        for (int i = 0; i <= markdownCode.length() - 3; ++i) {
            if (!markdownCode.substring(i, i + 3).equals("```")) continue;
            startIndex = i;
            delimiterLength = 3;
            while (i + delimiterLength < markdownCode.length() && markdownCode.charAt(i + delimiterLength) == '`') {
                ++delimiterLength;
            }
            break;
        }
        if (startIndex == -1) {
            return markdownCode;
        }
        for (contentStart = startIndex + delimiterLength; contentStart < markdownCode.length() && markdownCode.charAt(contentStart) != '\n'; ++contentStart) {
        }
        if (contentStart < markdownCode.length() && markdownCode.charAt(contentStart) == '\n') {
            ++contentStart;
        }
        if ((endIndex = markdownCode.indexOf(closingDelimiter = "`".repeat(delimiterLength), contentStart)) == -1) {
            return markdownCode.substring(contentStart);
        }
        return markdownCode.substring(contentStart, endIndex);
    }
}

