/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.analytic;

import com.alibaba.cloud.ai.annotation.ConditionalOnADBEnabled;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.request.SearchRequest;
import com.alibaba.cloud.ai.service.base.BaseSchemaService;
import com.alibaba.cloud.ai.service.base.BaseVectorStoreService;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.springframework.ai.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnADBEnabled
public class AnalyticSchemaService
extends BaseSchemaService {
    @Autowired
    public AnalyticSchemaService(DbConfig dbConfig, Gson gson, @Qualifier(value="analyticVectorStoreService") BaseVectorStoreService vectorStoreService) {
        super(dbConfig, gson, vectorStoreService);
    }

    @Override
    protected void addTableDocument(List<Document> tableDocuments, String tableName, String vectorType) {
        this.handleDocumentQuery(tableDocuments, tableName, vectorType, (String name) -> {
            SearchRequest req = new SearchRequest();
            req.setQuery(null);
            req.setFilterFormatted("jsonb_extract_path_text(metadata, 'vectorType') = '" + vectorType + "' and refdocid = '" + name + "'");
            return req;
        }, this.vectorStoreService::searchWithFilter);
    }

    @Override
    protected void addColumnsDocument(Map<String, Document> weightedColumns, String columnName, String vectorType) {
        this.handleDocumentQuery(weightedColumns, columnName, vectorType, (String name) -> {
            SearchRequest req = new SearchRequest();
            req.setQuery(null);
            req.setFilterFormatted("jsonb_extract_path_text(metadata, 'vectorType') = '" + vectorType + "' and refdocid = '" + name + "'");
            return req;
        }, this.vectorStoreService::searchWithFilter);
    }
}

