/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.business;

import com.alibaba.cloud.ai.dto.BusinessKnowledgeDTO;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BusinessKnowledgeRecallService {
    private static final String FIELD_GET_BY_DATASET_IDS = "SELECT\n\tbusiness_term,\n\tdescription,\n       \tsynonyms,\n\tis_recall,\n\tdata_set_id\nFROM business_knowledge WHERE data_set_id = ? AND is_recall = 1\n";
    private final JdbcTemplate jdbcTemplate;

    public BusinessKnowledgeRecallService(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"jdbcTemplate cannot be null");
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<BusinessKnowledgeDTO> getFieldByDataSetId(String dataSetId) {
        return this.jdbcTemplate.query(FIELD_GET_BY_DATASET_IDS, new Object[]{dataSetId}, (rs, rowNum) -> new BusinessKnowledgeDTO(rs.getString("business_term"), rs.getString("description"), rs.getString("synonyms"), rs.getObject("is_recall", Boolean.TYPE), rs.getString("data_set_id")));
    }
}

