/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.util;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionUtils.class);

    public static <T> T safeExecute(Supplier<T> operation, T defaultValue, String errorMessage) {
        try {
            return operation.get();
        }
        catch (Exception e) {
            logger.error("{}: {}", new Object[]{errorMessage, e.getMessage(), e});
            return defaultValue;
        }
    }

    public static void safeExecute(Runnable operation, String errorMessage) {
        try {
            operation.run();
        }
        catch (Exception e) {
            logger.error("{}: {}", new Object[]{errorMessage, e.getMessage(), e});
        }
    }

    public static RuntimeException wrapAsRuntimeException(Exception exception, String message) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(message, exception);
    }

    public static Throwable getRootCause(Throwable exception) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            return exception;
        }
        return ExceptionUtils.getRootCause(cause);
    }

    public static String getSimpleMessage(Throwable exception) {
        Throwable rootCause = ExceptionUtils.getRootCause(exception);
        String message = rootCause.getMessage();
        return message != null ? message : rootCause.getClass().getSimpleName();
    }
}

