/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.connector.support;

import com.alibaba.cloud.ai.connector.SqlExecutor;
import com.alibaba.cloud.ai.connector.bo.ResultSetBO;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class ResultSetBuilder {
    public static ResultSetBO buildFrom(ResultSet rs, String schema) throws SQLException {
        ResultSetMetaData data = rs.getMetaData();
        int columnsCount = data.getColumnCount();
        ResultSetBO resultSetBO = new ResultSetBO();
        String[] rowHead = new String[columnsCount];
        for (int i = 1; i <= columnsCount; ++i) {
            rowHead[i - 1] = data.getColumnLabel(i);
        }
        ArrayList resultSetData = Lists.newArrayList();
        for (int count = 0; rs.next() && count < SqlExecutor.RESULT_SET_LIMIT; ++count) {
            HashMap<String, String> kv = new HashMap<String, String>();
            for (String h : rowHead) {
                kv.put(h, rs.getString(h) == null ? "" : rs.getString(h));
            }
            resultSetData.add(kv);
        }
        List<String> cleanedHead = ResultSetBuilder.cleanColumnNames(Arrays.asList(rowHead));
        List<Map<String, String>> cleanedData = ResultSetBuilder.cleanResultSet(resultSetData);
        resultSetBO.setColumn(cleanedHead);
        resultSetBO.setData(cleanedData);
        return resultSetBO;
    }

    private static List<String> cleanColumnNames(List<String> columnNames) {
        return columnNames.stream().map(name -> StringUtils.remove((String)StringUtils.remove((String)name, (String)"`"), (String)"\"")).toList();
    }

    private static List<Map<String, String>> cleanResultSet(List<Map<String, String>> data) {
        return data.stream().map(row -> {
            HashMap cleanedRow = new HashMap();
            row.forEach((k, v) -> {
                String cleanedKey = StringUtils.remove((String)k, (String)"`");
                cleanedKey = StringUtils.remove((String)cleanedKey, (String)"\"");
                cleanedRow.put(cleanedKey, v);
            });
            return cleanedRow;
        }).toList();
    }
}

