/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.connector;

import com.alibaba.cloud.ai.connector.DBConnectionPool;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.enums.BizDataSourceTypeEnum;
import com.alibaba.cloud.ai.enums.DatabaseDialectEnum;
import com.alibaba.cloud.ai.enums.ErrorCodeEnum;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBConnectionPool
implements DBConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(AbstractDBConnectionPool.class);
    private static final ConcurrentHashMap<String, DataSource> DATA_SOURCE_CACHE = new ConcurrentHashMap();

    public abstract DatabaseDialectEnum getDialect();

    public abstract String getDriver();

    public abstract ErrorCodeEnum errorMapping(String var1);

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public ErrorCodeEnum ping(DbConfig config) {
        jdbcUrl = config.getUrl();
        try {
            connection = DriverManager.getConnection(jdbcUrl, config.getUsername(), config.getPassword());
            try {
                block18: {
                    block16: {
                        block17: {
                            stmt = connection.createStatement();
                            try {
                                if (!BizDataSourceTypeEnum.isPgDialect(config.getConnectionType())) ** GOTO lbl34
                                sql = "SELECT count(*) FROM information_schema.schemata WHERE schema_name = '%s'";
                                rs = stmt.executeQuery(String.format(sql, new Object[]{config.getSchema()}));
                                if (!rs.next()) break block16;
                                count = rs.getInt(1);
                                rs.close();
                                if (count != 0) break block16;
                                AbstractDBConnectionPool.log.info("the specified schema '{}' does not exist.", (Object)config.getSchema());
                                var8_13 = ErrorCodeEnum.SCHEMA_NOT_EXIST_3D070;
                                if (stmt == null) break block17;
                            }
                            catch (Throwable var5_8) {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable var6_11) {
                                        var5_8.addSuppressed(var6_11);
                                    }
                                }
                                throw var5_8;
                            }
                            stmt.close();
                        }
                        return var8_13;
                    }
                    rs.close();
lbl34:
                    // 2 sources

                    var5_7 = ErrorCodeEnum.SUCCESS;
                    if (stmt == null) break block18;
                    stmt.close();
                }
                return var5_7;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            AbstractDBConnectionPool.log.error("test db connection error, url:{}, state:{}, message:{}", new Object[]{jdbcUrl, e.getSQLState(), e.getMessage()});
            return this.errorMapping(e.getSQLState());
        }
    }

    @Override
    public Connection getConnection(DbConfig config) {
        log.info("Testing database connection.... db config: {}", (Object)config);
        ErrorCodeEnum pingResult = this.ping(config);
        if (pingResult != ErrorCodeEnum.SUCCESS) {
            throw new RuntimeException("Database connection test failed: " + pingResult);
        }
        String jdbcUrl = config.getUrl();
        try {
            String cacheKey = this.generateCacheKey(jdbcUrl, config.getUsername(), config.getPassword());
            DataSource dataSource = DATA_SOURCE_CACHE.computeIfAbsent(cacheKey, key -> {
                try {
                    log.debug("Creating new DataSource for key: {}", key);
                    return this.createdDataSource(jdbcUrl, config.getUsername(), config.getPassword());
                }
                catch (Exception e) {
                    log.error("Failed to create DataSource for key: {}", key, (Object)e);
                    throw new RuntimeException("Failed to create DataSource", e);
                }
            });
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            log.error("create db connection error, e:" + e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateCacheKey(String url, String username, String password) {
        return url + "|" + username + "|" + Objects.hashCode(password);
    }

    @Override
    public void close() {
        DATA_SOURCE_CACHE.values().forEach(dataSource -> {
            if (dataSource instanceof DruidDataSource) {
                ((DruidDataSource)dataSource).close();
            }
        });
        DATA_SOURCE_CACHE.clear();
        log.info("DataSource cache cleared");
    }

    public DataSource createdDataSource(String url, String username, String password) throws Exception {
        DruidDataSource dataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource(Map.of("driverClassName", this.getDriver(), "url", url, "username", username, "password", password, "initialSize", "1", "minIdle", "1", "maxActive", "3", "maxWait", "6000", "timeBetweenEvictionRunsMillis", "60000", "filters", "wall,stat"));
        dataSource.setBreakAfterAcquireFailure(Boolean.TRUE.booleanValue());
        dataSource.setConnectionErrorRetryAttempts(2);
        return dataSource;
    }
}

