/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.Agent;
import com.alibaba.cloud.ai.entity.ApiResponse;
import com.alibaba.cloud.ai.entity.ChatMessage;
import com.alibaba.cloud.ai.entity.ChatRequest;
import com.alibaba.cloud.ai.entity.ChatResponse;
import com.alibaba.cloud.ai.entity.ChatSession;
import com.alibaba.cloud.ai.service.AgentService;
import com.alibaba.cloud.ai.service.ChatMessageService;
import com.alibaba.cloud.ai.service.ChatSessionService;
import com.alibaba.cloud.ai.service.Nl2SqlService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@CrossOrigin(origins={"*"})
public class ChatController {
    private static final Logger log = LoggerFactory.getLogger(ChatController.class);
    @Autowired
    private AgentService agentService;
    @Autowired
    private ChatSessionService chatSessionService;
    @Autowired
    private ChatMessageService chatMessageService;
    @Autowired(required=false)
    private Nl2SqlService nl2SqlService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping(value={"/agent/{id}/sessions"})
    public ResponseEntity<List<ChatSession>> getAgentSessions(@PathVariable Integer id) {
        List<ChatSession> sessions = this.chatSessionService.findByAgentId(id);
        return ResponseEntity.ok(sessions);
    }

    @PostMapping(value={"/agent/{id}/sessions"})
    public ResponseEntity<ChatSession> createSession(@PathVariable Integer id, @RequestBody(required=false) Map<String, Object> request) {
        String title = request != null ? (String)request.get("title") : null;
        Long userId = request != null ? (Long)request.get("userId") : null;
        ChatSession session = this.chatSessionService.createSession(id, title, userId);
        return ResponseEntity.ok((Object)session);
    }

    @DeleteMapping(value={"/agent/{id}/sessions"})
    public ResponseEntity<ApiResponse> clearAgentSessions(@PathVariable Integer id) {
        this.chatSessionService.clearSessionsByAgentId(id);
        return ResponseEntity.ok((Object)ApiResponse.success("\u4f1a\u8bdd\u5df2\u6e05\u7a7a"));
    }

    @GetMapping(value={"/sessions/{sessionId}/messages"})
    public ResponseEntity<List<ChatMessage>> getSessionMessages(@PathVariable String sessionId) {
        List<ChatMessage> messages = this.chatMessageService.findBySessionId(sessionId);
        return ResponseEntity.ok(messages);
    }

    @PostMapping(value={"/agent/{id}/chat"})
    public ResponseEntity<ChatResponse> chat(@PathVariable Integer id, @RequestBody ChatRequest request) {
        try {
            Agent agent = this.agentService.findById(id.longValue());
            if (agent == null) {
                return ResponseEntity.notFound().build();
            }
            String sessionId = request.getSessionId();
            String userMessage = request.getMessage();
            if (sessionId == null || sessionId.trim().isEmpty()) {
                ChatSession newSession = this.chatSessionService.createSession(id, "\u65b0\u5bf9\u8bdd", null);
                sessionId = newSession.getId();
            } else {
                this.chatSessionService.updateSessionTime(sessionId);
            }
            this.chatMessageService.saveUserMessage(sessionId, userMessage);
            ChatResponse response = new ChatResponse(sessionId, "", "text");
            if (this.nl2SqlService != null) {
                try {
                    String sql = this.nl2SqlService.apply(userMessage);
                    response.setMessage("\u6211\u4e3a\u60a8\u751f\u6210\u4e86\u4ee5\u4e0bSQL\u67e5\u8be2\uff1a");
                    response.setMessageType("sql");
                    response.setSql(sql);
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    metadata.put("sql", sql);
                    metadata.put("originalQuery", userMessage);
                    String metadataJson = this.objectMapper.writeValueAsString(metadata);
                    this.chatMessageService.saveAssistantMessage(sessionId, response.getMessage(), "sql", metadataJson);
                }
                catch (IllegalArgumentException e) {
                    response.setMessage("\u62b1\u6b49\uff0c" + e.getMessage());
                    response.setMessageType("error");
                    response.setError(e.getMessage());
                    this.chatMessageService.saveAssistantMessage(sessionId, response.getMessage(), "error", null);
                }
                catch (Exception e) {
                    log.error("NL2SQL processing error for agent {}: {}", new Object[]{id, e.getMessage(), e});
                    response.setMessage("\u62b1\u6b49\uff0c\u5904\u7406\u60a8\u7684\u8bf7\u6c42\u65f6\u51fa\u73b0\u4e86\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    response.setMessageType("error");
                    response.setError("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef");
                    this.chatMessageService.saveAssistantMessage(sessionId, response.getMessage(), "error", null);
                }
            } else {
                response.setMessage("\u62b1\u6b49\uff0cNL2SQL\u670d\u52a1\u5f53\u524d\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                response.setMessageType("error");
                response.setError("\u670d\u52a1\u4e0d\u53ef\u7528");
                this.chatMessageService.saveAssistantMessage(sessionId, response.getMessage(), "error", null);
            }
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            log.error("Chat processing error for agent {}: {}", new Object[]{id, e.getMessage(), e});
            return ResponseEntity.internalServerError().body((Object)new ChatResponse(request.getSessionId(), "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", "error"));
        }
    }

    @PostMapping(value={"/sessions/{sessionId}/messages"})
    public ResponseEntity<ChatMessage> saveMessage(@PathVariable String sessionId, @RequestBody ChatMessage message) {
        try {
            message.setSessionId(sessionId);
            ChatMessage savedMessage = this.chatMessageService.saveMessage(message);
            this.chatSessionService.updateSessionTime(sessionId);
            return ResponseEntity.ok((Object)savedMessage);
        }
        catch (Exception e) {
            log.error("Save message error for session {}: {}", new Object[]{sessionId, e.getMessage(), e});
            return ResponseEntity.internalServerError().build();
        }
    }

    @PutMapping(value={"/sessions/{sessionId}/pin"})
    public ResponseEntity<ApiResponse> pinSession(@PathVariable String sessionId, @RequestBody Map<String, Object> request) {
        try {
            Boolean isPinned = (Boolean)request.get("isPinned");
            if (isPinned == null) {
                return ResponseEntity.badRequest().body((Object)ApiResponse.error("isPinned\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            this.chatSessionService.pinSession(sessionId, isPinned);
            String message = isPinned != false ? "\u4f1a\u8bdd\u5df2\u7f6e\u9876" : "\u4f1a\u8bdd\u5df2\u53d6\u6d88\u7f6e\u9876";
            return ResponseEntity.ok((Object)ApiResponse.success(message));
        }
        catch (Exception e) {
            log.error("Pin session error for session {}: {}", new Object[]{sessionId, e.getMessage(), e});
            return ResponseEntity.internalServerError().body((Object)ApiResponse.error("\u64cd\u4f5c\u5931\u8d25"));
        }
    }

    @PutMapping(value={"/sessions/{sessionId}/rename"})
    public ResponseEntity<ApiResponse> renameSession(@PathVariable String sessionId, @RequestBody Map<String, Object> request) {
        try {
            String newTitle = (String)request.get("title");
            if (newTitle == null || newTitle.trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)ApiResponse.error("\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            this.chatSessionService.renameSession(sessionId, newTitle.trim());
            return ResponseEntity.ok((Object)ApiResponse.success("\u4f1a\u8bdd\u5df2\u91cd\u547d\u540d"));
        }
        catch (Exception e) {
            log.error("Rename session error for session {}: {}", new Object[]{sessionId, e.getMessage(), e});
            return ResponseEntity.internalServerError().body((Object)ApiResponse.error("\u91cd\u547d\u540d\u5931\u8d25"));
        }
    }

    @DeleteMapping(value={"/sessions/{sessionId}"})
    public ResponseEntity<ApiResponse> deleteSession(@PathVariable String sessionId) {
        try {
            this.chatSessionService.deleteSession(sessionId);
            return ResponseEntity.ok((Object)ApiResponse.success("\u4f1a\u8bdd\u5df2\u5220\u9664"));
        }
        catch (Exception e) {
            log.error("Delete session error for session {}: {}", new Object[]{sessionId, e.getMessage(), e});
            return ResponseEntity.internalServerError().body((Object)ApiResponse.error("\u5220\u9664\u5931\u8d25"));
        }
    }
}

