/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.SemanticModel;
import com.alibaba.cloud.ai.service.SemanticModelService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/semantic-model"})
@CrossOrigin(origins={"*"})
public class SemanticModelController {
    private final SemanticModelService semanticModelService;

    public SemanticModelController(SemanticModelService semanticModelService) {
        this.semanticModelService = semanticModelService;
    }

    @GetMapping
    @ResponseBody
    public ResponseEntity<List<SemanticModel>> list(@RequestParam(required=false) String keyword, @RequestParam(required=false) Long agentId) {
        List<SemanticModel> result = keyword != null && !keyword.trim().isEmpty() ? this.semanticModelService.search(keyword) : (agentId != null ? this.semanticModelService.findByAgentId(agentId) : this.semanticModelService.findAll());
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<SemanticModel> get(@PathVariable Long id) {
        SemanticModel model = this.semanticModelService.findById(id);
        if (model == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)model);
    }

    @PostMapping
    @ResponseBody
    public ResponseEntity<SemanticModel> create(@RequestBody SemanticModel model) {
        SemanticModel saved = this.semanticModelService.save(model);
        return ResponseEntity.ok((Object)saved);
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<SemanticModel> update(@PathVariable Long id, @RequestBody SemanticModel model) {
        if (this.semanticModelService.findById(id) == null) {
            return ResponseEntity.notFound().build();
        }
        model.setId(id);
        SemanticModel updated = this.semanticModelService.save(model);
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        if (this.semanticModelService.findById(id) == null) {
            return ResponseEntity.notFound().build();
        }
        this.semanticModelService.deleteById(id);
        return ResponseEntity.ok().build();
    }
}

