/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.Agent;
import com.alibaba.cloud.ai.entity.AgentDatasource;
import com.alibaba.cloud.ai.service.AgentService;
import com.alibaba.cloud.ai.service.AgentVectorService;
import com.alibaba.cloud.ai.service.DatasourceService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Service;

@Service
public class AgentStartupInitializationService
implements ApplicationRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AgentStartupInitializationService.class);
    @Autowired
    private AgentService agentService;
    @Autowired
    private AgentVectorService agentVectorService;
    @Autowired
    private DatasourceService datasourceService;
    private final ExecutorService executorService = Executors.newFixedThreadPool(3);

    public void run(ApplicationArguments args) throws Exception {
        log.info("Starting automatic initialization of published agents...");
        try {
            CompletableFuture.runAsync(this::initializePublishedAgents, this.executorService).exceptionally(throwable -> {
                log.error("Error during agent initialization", throwable);
                return null;
            });
        }
        catch (Exception e) {
            log.error("Failed to start agent initialization process", (Throwable)e);
        }
    }

    private void initializePublishedAgents() {
        try {
            List<Agent> publishedAgents = this.agentService.findByStatus("published");
            if (publishedAgents.isEmpty()) {
                log.info("No published agents found, skipping initialization");
                return;
            }
            log.info("Found {} published agents, starting initialization...", (Object)publishedAgents.size());
            int successCount = 0;
            int failureCount = 0;
            for (Agent agent : publishedAgents) {
                try {
                    boolean initialized = this.initializeAgentDataSource(agent);
                    if (initialized) {
                        ++successCount;
                        log.info("Successfully initialized agent: {} (ID: {})", (Object)agent.getName(), (Object)agent.getId());
                    } else {
                        ++failureCount;
                        log.warn("Failed to initialize agent: {} (ID: {}) - no active datasource or tables", (Object)agent.getName(), (Object)agent.getId());
                    }
                }
                catch (Exception e) {
                    ++failureCount;
                    log.error("Error initializing agent: {} (ID: {})", new Object[]{agent.getName(), agent.getId(), e});
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            log.info("Agent initialization completed. Success: {}, Failed: {}, Total: {}", new Object[]{successCount, failureCount, publishedAgents.size()});
        }
        catch (Exception e) {
            log.error("Error during published agents initialization", (Throwable)e);
        }
    }

    private boolean initializeAgentDataSource(Agent agent) {
        try {
            Long agentId = agent.getId();
            Map<String, Object> statistics = this.agentVectorService.getVectorStatistics(agentId);
            boolean hasData = (Boolean)statistics.getOrDefault("hasData", false);
            int documentCount = (Integer)statistics.getOrDefault("documentCount", 0);
            if (hasData && documentCount > 0) {
                log.info("Agent {} already has vector data (documents: {}), skipping initialization", (Object)agentId, (Object)documentCount);
                return true;
            }
            List agentDatasources = this.datasourceService.getAgentDatasources(Integer.valueOf(agentId.intValue()));
            if (agentDatasources.isEmpty()) {
                log.warn("Agent {} has no associated datasources", (Object)agentId);
                return false;
            }
            AgentDatasource activeDatasource = null;
            for (AgentDatasource agentDatasource : agentDatasources) {
                if (agentDatasource.getIsActive() == null || agentDatasource.getIsActive() != 1) continue;
                activeDatasource = agentDatasource;
                break;
            }
            if (activeDatasource == null) {
                log.warn("Agent {} has no active datasource", (Object)agentId);
                return false;
            }
            Integer datasourceId = activeDatasource.getDatasourceId();
            List<String> tables = this.agentVectorService.getDatasourceTables(datasourceId);
            if (tables.isEmpty()) {
                log.warn("Datasource {} has no tables available for agent {}", (Object)datasourceId, (Object)agentId);
                return false;
            }
            log.info("Initializing agent {} with datasource {} and {} tables", new Object[]{agentId, datasourceId, tables.size()});
            Boolean result = this.agentVectorService.initializeSchemaForAgentWithDatasource(agentId, datasourceId, tables);
            if (result.booleanValue()) {
                log.info("Successfully initialized datasource for agent {} with {} tables", (Object)agentId, (Object)tables.size());
                return true;
            }
            log.error("Failed to initialize datasource for agent {}", (Object)agentId);
            return false;
        }
        catch (Exception e) {
            log.error("Error initializing datasource for agent {}", (Object)agent.getId(), (Object)e);
            return false;
        }
    }

    public void destroy() throws Exception {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            log.info("Shutting down agent initialization executor service");
            this.executorService.shutdown();
        }
    }
}

