/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.annotation.ConditionalOnADBEnabled;
import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.bo.ColumnInfoBO;
import com.alibaba.cloud.ai.connector.bo.DbQueryParameter;
import com.alibaba.cloud.ai.connector.bo.ForeignKeyInfoBO;
import com.alibaba.cloud.ai.connector.bo.TableInfoBO;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.request.DeleteRequest;
import com.alibaba.cloud.ai.request.EvidenceRequest;
import com.alibaba.cloud.ai.request.SchemaInitRequest;
import com.alibaba.cloud.ai.request.SearchRequest;
import com.alibaba.cloud.ai.service.VectorStoreManagementService;
import com.alibaba.cloud.ai.vectorstore.analyticdb.AnalyticDbVectorStoreProperties;
import com.aliyun.gpdb20160503.Client;
import com.aliyun.gpdb20160503.models.DeleteCollectionDataRequest;
import com.aliyun.gpdb20160503.models.DeleteCollectionDataResponse;
import com.aliyun.gpdb20160503.models.QueryCollectionDataRequest;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponse;
import com.aliyun.gpdb20160503.models.QueryCollectionDataResponseBody;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnADBEnabled
public class AnalyticDbVectorStoreManagementService
implements VectorStoreManagementService {
    private static final String CONTENT_FIELD_NAME = "content";
    private static final String METADATA_FIELD_NAME = "metadata";
    @Autowired
    @Qualifier(value="dashscopeEmbeddingModel")
    private EmbeddingModel embeddingModel;
    @Autowired
    private VectorStore vectorStore;
    @Autowired
    @Qualifier(value="mysqlAccessor")
    private Accessor dbAccessor;
    @Autowired
    private AnalyticDbVectorStoreProperties analyticDbVectorStoreProperties;
    @Autowired
    private Client client;
    @Autowired
    private Gson gson;

    @Override
    public Boolean addEvidence(List<EvidenceRequest> evidenceRequests) {
        ArrayList<Document> evidences = new ArrayList<Document>();
        for (EvidenceRequest req : evidenceRequests) {
            Document doc = new Document(UUID.randomUUID().toString(), req.getContent(), Map.of("evidenceType", req.getType(), "vectorType", "evidence"));
            evidences.add(doc);
        }
        this.vectorStore.add(evidences);
        return true;
    }

    public List<Double> embed(String text) {
        float[] embedded = this.embeddingModel.embed(text);
        ArrayList<Double> result = new ArrayList<Double>();
        for (float value : embedded) {
            result.add(Double.valueOf(value));
        }
        return result;
    }

    public List<Document> search(SearchRequest searchRequest) throws Exception {
        String filterTemplate = "jsonb_extract_path_text(metadata, 'vectorType') = '%s'";
        String filterFormatted = String.format(filterTemplate, searchRequest.getVectorType());
        QueryCollectionDataRequest request = new QueryCollectionDataRequest().setDBInstanceId(this.analyticDbVectorStoreProperties.getDbInstanceId()).setRegionId(this.analyticDbVectorStoreProperties.getRegionId()).setNamespace(this.analyticDbVectorStoreProperties.getNamespace()).setNamespacePassword(this.analyticDbVectorStoreProperties.getNamespacePassword()).setCollection(this.analyticDbVectorStoreProperties.getCollectName()).setIncludeValues(Boolean.valueOf(false)).setMetrics(this.analyticDbVectorStoreProperties.getMetrics()).setVector(this.embed(searchRequest.getQuery())).setContent(searchRequest.getQuery()).setTopK(Long.valueOf(searchRequest.getTopK())).setFilter(filterFormatted);
        try {
            QueryCollectionDataResponse response = this.client.queryCollectionData(request);
            ArrayList<Document> documents = new ArrayList<Document>();
            if (response.getBody() != null && response.getBody().getMatches() != null) {
                for (QueryCollectionDataResponseBody.QueryCollectionDataResponseBodyMatchesMatch match : response.getBody().getMatches().getMatch()) {
                    if (match.getScore() == null || !(match.getScore() > 0.2)) continue;
                    Map metadata = match.getMetadata();
                    String pageContent = (String)metadata.get(CONTENT_FIELD_NAME);
                    Map metadataJson = (Map)new ObjectMapper().readValue((String)metadata.get(METADATA_FIELD_NAME), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                    Document doc = new Document(match.getId(), pageContent, metadataJson);
                    documents.add(doc);
                }
            }
            return documents;
        }
        catch (Exception e) {
            throw new Exception("Failed to perform vector search: " + e.getMessage(), e);
        }
    }

    @Override
    public Boolean deleteDocuments(DeleteRequest deleteRequest) throws Exception {
        try {
            String filterExpression;
            if (deleteRequest.getId() != null && !deleteRequest.getId().isEmpty()) {
                filterExpression = String.format("id = '%s'", deleteRequest.getId());
            } else if (deleteRequest.getVectorType() != null && !deleteRequest.getVectorType().isEmpty()) {
                filterExpression = String.format("jsonb_extract_path_text(metadata, 'vectorType') = '%s'", deleteRequest.getVectorType());
            } else {
                throw new IllegalArgumentException("Either id or vectorType must be specified.");
            }
            DeleteCollectionDataRequest request = this.getDeleteCollectionDataRequest(filterExpression);
            DeleteCollectionDataResponse deleteCollectionDataResponse = this.client.deleteCollectionData(request);
            return true;
        }
        catch (Exception e) {
            throw new Exception("Failed to delete collection data by filterExpression: " + e.getMessage(), e);
        }
    }

    private DeleteCollectionDataRequest getDeleteCollectionDataRequest(String query) {
        return new DeleteCollectionDataRequest().setDBInstanceId(this.analyticDbVectorStoreProperties.getDbInstanceId()).setRegionId(this.analyticDbVectorStoreProperties.getRegionId()).setNamespace(this.analyticDbVectorStoreProperties.getNamespace()).setNamespacePassword(this.analyticDbVectorStoreProperties.getNamespacePassword()).setCollection(this.analyticDbVectorStoreProperties.getCollectName()).setCollectionData(null).setCollectionDataFilter(query);
    }

    @Override
    public Boolean schema(SchemaInitRequest schemaInitRequest) throws Exception {
        DbConfig dbConfig = schemaInitRequest.getDbConfig();
        DbQueryParameter dqp = DbQueryParameter.from((DbConfig)dbConfig).setSchema(dbConfig.getSchema()).setTables(schemaInitRequest.getTables());
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.setVectorType("column");
        this.deleteDocuments(deleteRequest);
        deleteRequest.setVectorType("table");
        this.deleteDocuments(deleteRequest);
        List foreignKeyInfoBOS = this.dbAccessor.showForeignKeys(dbConfig, dqp);
        Map<String, List<String>> foreignKeyMap = this.buildForeignKeyMap(foreignKeyInfoBOS);
        List tableInfoBOS = this.dbAccessor.fetchTables(dbConfig, dqp);
        for (TableInfoBO tableInfoBO : tableInfoBOS) {
            this.processTable(tableInfoBO, dqp, dbConfig);
        }
        List columnDocuments = tableInfoBOS.stream().flatMap(table -> {
            try {
                return this.dbAccessor.showColumns(dbConfig, dqp).stream().map(column -> this.convertToDocument((TableInfoBO)table, (ColumnInfoBO)column));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        this.vectorStore.add(columnDocuments);
        List tableDocuments = tableInfoBOS.stream().map(this::convertTableToDocument).collect(Collectors.toList());
        this.vectorStore.add(tableDocuments);
        return true;
    }

    private void processTable(TableInfoBO tableInfoBO, DbQueryParameter dqp, DbConfig dbConfig) throws Exception {
        dqp.setTable(tableInfoBO.getName());
        List columnInfoBOS = this.dbAccessor.showColumns(dbConfig, dqp);
        for (ColumnInfoBO columnInfoBO : columnInfoBOS) {
            dqp.setColumn(columnInfoBO.getName());
            List<String> sampleColumn = this.dbAccessor.sampleColumn(dbConfig, dqp);
            sampleColumn = ((List)Optional.ofNullable(sampleColumn).orElse(new ArrayList())).stream().filter(Objects::nonNull).distinct().limit(3L).filter(s -> s.length() <= 100).toList();
            columnInfoBO.setTableName(tableInfoBO.getName());
            columnInfoBO.setSamples(this.gson.toJson(sampleColumn));
        }
        ColumnInfoBO primaryColumnDO = columnInfoBOS.stream().filter(ColumnInfoBO::isPrimary).findFirst().orElse(new ColumnInfoBO());
        tableInfoBO.setPrimaryKey(primaryColumnDO.getName());
        tableInfoBO.setForeignKey(String.join((CharSequence)"\u3001", this.buildForeignKeyList(tableInfoBO.getName())));
    }

    private Map<String, List<String>> buildForeignKeyMap(List<ForeignKeyInfoBO> foreignKeyInfoBOS) {
        HashMap<String, List<String>> foreignKeyMap = new HashMap<String, List<String>>();
        for (ForeignKeyInfoBO fk : foreignKeyInfoBOS) {
            String key = fk.getTable() + "." + fk.getColumn() + "=" + fk.getReferencedTable() + "." + fk.getReferencedColumn();
            foreignKeyMap.computeIfAbsent(fk.getTable(), k -> new ArrayList()).add(key);
            foreignKeyMap.computeIfAbsent(fk.getReferencedTable(), k -> new ArrayList()).add(key);
        }
        return foreignKeyMap;
    }

    private List<String> buildForeignKeyList(String tableName) {
        return new ArrayList<String>();
    }

    public Document convertToDocument(TableInfoBO tableInfoBO, ColumnInfoBO columnInfoBO) {
        String text = Optional.ofNullable(columnInfoBO.getDescription()).orElse(columnInfoBO.getName());
        Map<String, String> metadata = Map.of("name", columnInfoBO.getName(), "tableName", tableInfoBO.getName(), "description", Optional.ofNullable(columnInfoBO.getDescription()).orElse(""), "type", columnInfoBO.getType(), "primary", columnInfoBO.isPrimary(), "notnull", columnInfoBO.isNotnull(), "vectorType", "column");
        if (columnInfoBO.getSamples() != null) {
            metadata.put("samples", columnInfoBO.getSamples());
        }
        return new Document(columnInfoBO.getName(), text, metadata);
    }

    public Document convertTableToDocument(TableInfoBO tableInfoBO) {
        String text = Optional.ofNullable(tableInfoBO.getDescription()).orElse(tableInfoBO.getName());
        Map<String, String> metadata = Map.of("schema", Optional.ofNullable(tableInfoBO.getSchema()).orElse(""), "name", tableInfoBO.getName(), "description", Optional.ofNullable(tableInfoBO.getDescription()).orElse(""), "foreignKey", Optional.ofNullable(tableInfoBO.getForeignKey()).orElse(""), "primaryKey", Optional.ofNullable(tableInfoBO.getPrimaryKey()).orElse(""), "vectorType", "table");
        return new Document(tableInfoBO.getName(), text, metadata);
    }
}

