/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.Agent;
import com.alibaba.cloud.ai.service.AgentService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/agent"})
@CrossOrigin(origins={"*"})
public class AgentController {
    private final AgentService agentService;

    public AgentController(AgentService agentService) {
        this.agentService = agentService;
    }

    @GetMapping
    @ResponseBody
    public ResponseEntity<List<Agent>> list(@RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        List<Agent> result = keyword != null && !keyword.trim().isEmpty() ? this.agentService.search(keyword) : (status != null && !status.trim().isEmpty() ? this.agentService.findByStatus(status) : this.agentService.findAll());
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<Agent> get(@PathVariable Long id) {
        Agent agent = this.agentService.findById(id);
        if (agent == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)agent);
    }

    @PostMapping
    @ResponseBody
    public ResponseEntity<Agent> create(@RequestBody Agent agent) {
        if (agent.getStatus() == null || agent.getStatus().trim().isEmpty()) {
            agent.setStatus("draft");
        }
        Agent saved = this.agentService.save(agent);
        return ResponseEntity.ok((Object)saved);
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<Agent> update(@PathVariable Long id, @RequestBody Agent agent) {
        if (this.agentService.findById(id) == null) {
            return ResponseEntity.notFound().build();
        }
        agent.setId(id);
        Agent updated = this.agentService.save(agent);
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseBody
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        if (this.agentService.findById(id) == null) {
            return ResponseEntity.notFound().build();
        }
        this.agentService.deleteById(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/publish"})
    @ResponseBody
    public ResponseEntity<Agent> publish(@PathVariable Long id) {
        Agent agent = this.agentService.findById(id);
        if (agent == null) {
            return ResponseEntity.notFound().build();
        }
        agent.setStatus("published");
        Agent updated = this.agentService.save(agent);
        return ResponseEntity.ok((Object)updated);
    }

    @PostMapping(value={"/{id}/offline"})
    @ResponseBody
    public ResponseEntity<Agent> offline(@PathVariable Long id) {
        Agent agent = this.agentService.findById(id);
        if (agent == null) {
            return ResponseEntity.notFound().build();
        }
        agent.setStatus("offline");
        Agent updated = this.agentService.save(agent);
        return ResponseEntity.ok((Object)updated);
    }
}

