/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.ApiResponse;
import com.alibaba.cloud.ai.entity.BusinessKnowledge;
import com.alibaba.cloud.ai.entity.BusinessKnowledgeDTO;
import com.alibaba.cloud.ai.service.BusinessKnowledgePersistenceService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/knowledge"})
public class BusinessKnowledgePersistenceController {
    private final BusinessKnowledgePersistenceService businessKnowledgePersistenceService;

    public BusinessKnowledgePersistenceController(BusinessKnowledgePersistenceService businessKnowledgePersistenceService) {
        this.businessKnowledgePersistenceService = businessKnowledgePersistenceService;
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<ApiResponse> addField(@RequestBody BusinessKnowledgeDTO knowledgeDTO) {
        this.businessKnowledgePersistenceService.addKnowledge(knowledgeDTO);
        return ResponseEntity.ok((Object)ApiResponse.success("\u4e1a\u52a1\u77e5\u8bc6\u6dfb\u52a0\u6210\u529f"));
    }

    @PostMapping(value={"/addList"})
    public ResponseEntity<ApiResponse> addFields(@RequestBody List<BusinessKnowledgeDTO> knowledgeDTOs) {
        this.businessKnowledgePersistenceService.addKnowledgeList(knowledgeDTOs);
        return ResponseEntity.ok((Object)ApiResponse.success("\u6279\u91cf\u4e1a\u52a1\u77e5\u8bc6\u6dfb\u52a0\u6210\u529f"));
    }

    @GetMapping(value={"/datasetIds"})
    public ResponseEntity<List<String>> getDataSetIds() {
        List<String> datasetIds = this.businessKnowledgePersistenceService.getDataSetIds();
        return ResponseEntity.ok(datasetIds);
    }

    @GetMapping(value={"/dataset/{datasetId}"})
    public ResponseEntity<List<BusinessKnowledge>> getDataSetById(@PathVariable String datasetId) {
        List<BusinessKnowledge> knowledge = this.businessKnowledgePersistenceService.getFieldByDataSetId(datasetId);
        return ResponseEntity.ok(knowledge);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<BusinessKnowledge>> searchFields(@RequestParam String content) {
        List<BusinessKnowledge> knowledge = this.businessKnowledgePersistenceService.searchFields(content);
        return ResponseEntity.ok(knowledge);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<ApiResponse> deleteFieldById(@PathVariable long id) {
        this.businessKnowledgePersistenceService.deleteFieldById(id);
        return ResponseEntity.ok((Object)ApiResponse.success("\u4e1a\u52a1\u77e5\u8bc6\u5220\u9664\u6210\u529f"));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<ApiResponse> updateField(@PathVariable long id, @RequestBody BusinessKnowledgeDTO knowledgeDTO) {
        this.businessKnowledgePersistenceService.updateField(knowledgeDTO, id);
        return ResponseEntity.ok((Object)ApiResponse.success("\u4e1a\u52a1\u77e5\u8bc6\u66f4\u65b0\u6210\u529f"));
    }

    @GetMapping(value={"/agent/{agentId}"})
    public ResponseEntity<List<BusinessKnowledge>> getKnowledgeByAgentId(@PathVariable String agentId) {
        List<BusinessKnowledge> knowledge = this.businessKnowledgePersistenceService.getKnowledgeByAgentId(agentId);
        return ResponseEntity.ok(knowledge);
    }

    @PostMapping(value={"/agent/{agentId}/add"})
    public ResponseEntity<ApiResponse> addKnowledgeForAgent(@PathVariable String agentId, @RequestBody BusinessKnowledgeDTO knowledgeDTO) {
        knowledgeDTO.setAgentId(agentId);
        this.businessKnowledgePersistenceService.addKnowledge(knowledgeDTO);
        return ResponseEntity.ok((Object)ApiResponse.success("\u4e1a\u52a1\u77e5\u8bc6\u6dfb\u52a0\u6210\u529f"));
    }

    @PostMapping(value={"/agent/{agentId}/addList"})
    public ResponseEntity<ApiResponse> addKnowledgeListForAgent(@PathVariable String agentId, @RequestBody List<BusinessKnowledgeDTO> knowledgeDTOs) {
        knowledgeDTOs.forEach(dto -> dto.setAgentId(agentId));
        this.businessKnowledgePersistenceService.addKnowledgeList(knowledgeDTOs);
        return ResponseEntity.ok((Object)ApiResponse.success("\u6279\u91cf\u4e1a\u52a1\u77e5\u8bc6\u6dfb\u52a0\u6210\u529f"));
    }

    @DeleteMapping(value={"/agent/{agentId}"})
    public ResponseEntity<ApiResponse> deleteKnowledgeByAgentId(@PathVariable String agentId) {
        this.businessKnowledgePersistenceService.deleteKnowledgeByAgentId(agentId);
        return ResponseEntity.ok((Object)ApiResponse.success("\u667a\u80fd\u4f53\u4e1a\u52a1\u77e5\u8bc6\u5220\u9664\u6210\u529f"));
    }

    @GetMapping(value={"/agent/{agentId}/search"})
    public ResponseEntity<List<BusinessKnowledge>> searchKnowledgeInAgent(@PathVariable String agentId, @RequestParam String content) {
        List<BusinessKnowledge> knowledge = this.businessKnowledgePersistenceService.searchKnowledgeInAgent(agentId, content);
        return ResponseEntity.ok(knowledge);
    }
}

