/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.dto.PromptConfigDTO;
import com.alibaba.cloud.ai.entity.UserPromptConfig;
import com.alibaba.cloud.ai.service.UserPromptConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prompt-config"})
@CrossOrigin(origins={"*"}, maxAge=3600L)
public class PromptConfigController {
    private static final Logger logger = LoggerFactory.getLogger(PromptConfigController.class);
    private final UserPromptConfigService promptConfigService;

    public PromptConfigController(UserPromptConfigService promptConfigService) {
        this.promptConfigService = promptConfigService;
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<Map<String, Object>> saveConfig(@RequestBody PromptConfigDTO configDTO) {
        try {
            logger.info("\u4fdd\u5b58\u63d0\u793a\u8bcd\u914d\u7f6e\u8bf7\u6c42\uff1a{}", (Object)configDTO);
            UserPromptConfig savedConfig = this.promptConfigService.saveOrUpdateConfig(configDTO);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "\u914d\u7f6e\u4fdd\u5b58\u6210\u529f");
            response.put("data", savedConfig);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u63d0\u793a\u8bcd\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> getConfig(@PathVariable String id) {
        try {
            UserPromptConfig config = this.promptConfigService.getConfigById(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (config != null) {
                response.put("success", true);
                response.put("data", config);
            } else {
                response.put("success", false);
                response.put("message", "\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<Map<String, Object>> getAllConfigs() {
        try {
            List configs = this.promptConfigService.getAllConfigs();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("data", configs);
            response.put("total", configs.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/list-by-type/{promptType}"})
    public ResponseEntity<Map<String, Object>> getConfigsByType(@PathVariable String promptType) {
        try {
            List configs = this.promptConfigService.getConfigsByType(promptType);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("data", configs);
            response.put("total", configs.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/active/{promptType}"})
    public ResponseEntity<Map<String, Object>> getActiveConfig(@PathVariable String promptType) {
        try {
            UserPromptConfig config = this.promptConfigService.getActiveConfigByType(promptType);
            HashMap<String, Boolean> response = new HashMap<String, Boolean>();
            response.put("success", true);
            response.put("data", (Boolean)config);
            response.put("hasCustomConfig", config != null);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u542f\u7528\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u542f\u7528\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Object>> deleteConfig(@PathVariable String id) {
        try {
            boolean deleted = this.promptConfigService.deleteConfig(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (deleted) {
                response.put("success", true);
                response.put("message", "\u914d\u7f6e\u5220\u9664\u6210\u529f");
            } else {
                response.put("success", false);
                response.put("message", "\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5220\u9664\u5931\u8d25");
            }
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u5220\u9664\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PostMapping(value={"/{id}/enable"})
    public ResponseEntity<Map<String, Object>> enableConfig(@PathVariable String id) {
        try {
            boolean enabled = this.promptConfigService.enableConfig(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (enabled) {
                response.put("success", true);
                response.put("message", "\u914d\u7f6e\u542f\u7528\u6210\u529f");
            } else {
                response.put("success", false);
                response.put("message", "\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u542f\u7528\u5931\u8d25");
            }
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u542f\u7528\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u542f\u7528\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @PostMapping(value={"/{id}/disable"})
    public ResponseEntity<Map<String, Object>> disableConfig(@PathVariable String id) {
        try {
            boolean disabled = this.promptConfigService.disableConfig(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (disabled) {
                response.put("success", true);
                response.put("message", "\u914d\u7f6e\u7981\u7528\u6210\u529f");
            } else {
                response.put("success", false);
                response.put("message", "\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u7981\u7528\u5931\u8d25");
            }
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u7981\u7528\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u7981\u7528\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/types"})
    public ResponseEntity<Map<String, Object>> getSupportedPromptTypes() {
        try {
            String[] types = new String[]{"report-generator", "planner", "sql-generator", "python-generator", "rewrite"};
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("data", types);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u652f\u6301\u7684\u63d0\u793a\u8bcd\u7c7b\u578b\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", "\u83b7\u53d6\u652f\u6301\u7684\u63d0\u793a\u8bcd\u7c7b\u578b\u5931\u8d25\uff1a" + e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }
}

