/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.AgentKnowledge;
import java.sql.PreparedStatement;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class AgentKnowledgeService {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<AgentKnowledge> getKnowledgeByAgentId(Integer agentId) {
        String sql = "SELECT * FROM agent_knowledge WHERE agent_id = ? ORDER BY create_time DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(AgentKnowledge.class), new Object[]{agentId});
    }

    public AgentKnowledge getKnowledgeById(Integer id) {
        String sql = "SELECT * FROM agent_knowledge WHERE id = ?";
        List results = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(AgentKnowledge.class), new Object[]{id});
        return results.isEmpty() ? null : (AgentKnowledge)results.get(0);
    }

    public AgentKnowledge createKnowledge(AgentKnowledge knowledge) {
        String sql = "INSERT INTO agent_knowledge (agent_id, title, content, type, category, tags, status, source_url, file_path, file_size, file_type, embedding_status, creator_id, create_time, update_time) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        LocalDateTime now = LocalDateTime.now();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement(sql, 1);
            ps.setObject(1, knowledge.getAgentId());
            ps.setString(2, knowledge.getTitle());
            ps.setString(3, knowledge.getContent());
            ps.setString(4, knowledge.getType() != null ? knowledge.getType() : "document");
            ps.setString(5, knowledge.getCategory());
            ps.setString(6, knowledge.getTags());
            ps.setString(7, knowledge.getStatus() != null ? knowledge.getStatus() : "active");
            ps.setString(8, knowledge.getSourceUrl());
            ps.setString(9, knowledge.getFilePath());
            ps.setObject(10, knowledge.getFileSize());
            ps.setString(11, knowledge.getFileType());
            ps.setString(12, knowledge.getEmbeddingStatus() != null ? knowledge.getEmbeddingStatus() : "pending");
            ps.setObject(13, knowledge.getCreatorId());
            ps.setObject(14, now);
            ps.setObject(15, now);
            return ps;
        }, (KeyHolder)keyHolder);
        Integer generatedId = keyHolder.getKey().intValue();
        knowledge.setId(generatedId);
        knowledge.setCreateTime(now);
        knowledge.setUpdateTime(now);
        return knowledge;
    }

    public AgentKnowledge updateKnowledge(Integer id, AgentKnowledge knowledge) {
        String sql = "UPDATE agent_knowledge SET title = ?, content = ?, type = ?, category = ?, tags = ?, status = ?, source_url = ?, file_path = ?, file_size = ?, file_type = ?, embedding_status = ?, update_time = ? WHERE id = ?";
        LocalDateTime now = LocalDateTime.now();
        int updatedRows = this.jdbcTemplate.update(sql, new Object[]{knowledge.getTitle(), knowledge.getContent(), knowledge.getType(), knowledge.getCategory(), knowledge.getTags(), knowledge.getStatus(), knowledge.getSourceUrl(), knowledge.getFilePath(), knowledge.getFileSize(), knowledge.getFileType(), knowledge.getEmbeddingStatus(), now, id});
        if (updatedRows > 0) {
            knowledge.setId(id);
            knowledge.setUpdateTime(now);
            return knowledge;
        }
        return null;
    }

    public boolean deleteKnowledge(Integer id) {
        String sql = "DELETE FROM agent_knowledge WHERE id = ?";
        int deletedRows = this.jdbcTemplate.update(sql, new Object[]{id});
        return deletedRows > 0;
    }

    public List<AgentKnowledge> getKnowledgeByType(Integer agentId, String type) {
        String sql = "SELECT * FROM agent_knowledge WHERE agent_id = ? AND type = ? ORDER BY create_time DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(AgentKnowledge.class), new Object[]{agentId, type});
    }

    public List<AgentKnowledge> getKnowledgeByStatus(Integer agentId, String status) {
        String sql = "SELECT * FROM agent_knowledge WHERE agent_id = ? AND status = ? ORDER BY create_time DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(AgentKnowledge.class), new Object[]{agentId, status});
    }

    public List<AgentKnowledge> searchKnowledge(Integer agentId, String keyword) {
        String sql = "SELECT * FROM agent_knowledge WHERE agent_id = ? AND (title LIKE ? OR content LIKE ? OR tags LIKE ?) ORDER BY create_time DESC";
        String searchPattern = "%" + keyword + "%";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(AgentKnowledge.class), new Object[]{agentId, searchPattern, searchPattern, searchPattern});
    }

    public int batchUpdateStatus(List<Integer> ids, String status) {
        String sql = "UPDATE agent_knowledge SET status = ?, update_time = ? WHERE id = ?";
        LocalDateTime now = LocalDateTime.now();
        int totalUpdated = 0;
        for (Integer id : ids) {
            totalUpdated += this.jdbcTemplate.update(sql, new Object[]{status, now, id});
        }
        return totalUpdated;
    }

    public int countKnowledgeByAgent(Integer agentId) {
        String sql = "SELECT COUNT(*) FROM agent_knowledge WHERE agent_id = ?";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{agentId});
    }

    public List<Object[]> countKnowledgeByType(Integer agentId) {
        String sql = "SELECT type, COUNT(*) as count FROM agent_knowledge WHERE agent_id = ? GROUP BY type";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> new Object[]{rs.getString("type"), rs.getInt("count")}, new Object[]{agentId});
    }
}

