/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.ChatMessage;
import com.alibaba.cloud.ai.mapper.ChatMessageMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatMessageService {
    private static final Logger log = LoggerFactory.getLogger(ChatMessageService.class);
    @Autowired
    private ChatMessageMapper chatMessageMapper;

    public List<ChatMessage> findBySessionId(String sessionId) {
        return this.chatMessageMapper.selectBySessionId(sessionId);
    }

    public ChatMessage saveMessage(ChatMessage message) {
        this.chatMessageMapper.insert(message);
        log.info("Saved message: {} for session: {}", (Object)message.getId(), (Object)message.getSessionId());
        return message;
    }

    public ChatMessage saveUserMessage(String sessionId, String content) {
        ChatMessage message = new ChatMessage(sessionId, "user", content, "text");
        return this.saveMessage(message);
    }

    public ChatMessage saveAssistantMessage(String sessionId, String content, String messageType, String metadata) {
        ChatMessage message = new ChatMessage(sessionId, "assistant", content, messageType, metadata);
        return this.saveMessage(message);
    }
}

