/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis;

import com.alibaba.cloud.ai.memory.redis.serializer.MessageDeserializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.ai.chat.messages.Message;

public abstract class BaseRedisChatMemoryRepository
implements ChatMemoryRepository,
AutoCloseable {
    protected static final Logger logger = LoggerFactory.getLogger(BaseRedisChatMemoryRepository.class);
    protected static final String DEFAULT_KEY_PREFIX = "spring_ai_alibaba_chat_memory:";
    protected final ObjectMapper objectMapper = new ObjectMapper();

    public BaseRedisChatMemoryRepository() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Message.class, (JsonDeserializer)new MessageDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    protected Message deserializeMessage(String messageStr) {
        try {
            return (Message)this.objectMapper.readValue(messageStr, Message.class);
        }
        catch (JsonProcessingException e) {
            logger.error("Deserialization error for message: {}", (Object)messageStr, (Object)e);
            return null;
        }
    }

    protected String serializeMessage(Message message) {
        try {
            return this.objectMapper.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error serializing message", e);
        }
    }
}

