/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis;

import com.alibaba.cloud.ai.memory.redis.BaseRedisChatMemoryRepository;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LettuceRedisChatMemoryRepository
extends BaseRedisChatMemoryRepository {
    private static final Logger logger = LoggerFactory.getLogger(LettuceRedisChatMemoryRepository.class);
    private final RedisConnectionFactory connectionFactory;
    private final RedisTemplate<String, String> redisTemplate;

    private LettuceRedisChatMemoryRepository(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory cannot be null");
        this.connectionFactory = connectionFactory;
        this.redisTemplate = this.createRedisTemplate(connectionFactory);
    }

    private RedisTemplate<String, String> createRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate(connectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    public static RedisBuilder builder() {
        return new RedisBuilder();
    }

    public List<String> findConversationIds() {
        Set keys = this.redisTemplate.keys((Object)"spring_ai_alibaba_chat_memory:*");
        return keys.stream().map(key -> key.substring("spring_ai_alibaba_chat_memory:".length())).collect(Collectors.toList());
    }

    public List<Message> findByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        List messageStrings = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)messageStrings)) {
            return Collections.emptyList();
        }
        return messageStrings.stream().map(this::deserializeMessage).collect(Collectors.toList());
    }

    public void saveAll(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        List<String> messageJsons = messages.stream().map(this::serializeMessage).toList();
        try (RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();){
            connection.keyCommands().del((byte[][])new byte[][]{key.getBytes()});
            if (!messageJsons.isEmpty()) {
                byte[][] values = new byte[messageJsons.size()][];
                for (int i = 0; i < messageJsons.size(); ++i) {
                    values[i] = messageJsons.get(i).getBytes();
                }
                connection.listCommands().rPush(key.getBytes(), (byte[][])values);
            }
        }
    }

    public void deleteByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        this.redisTemplate.delete((Object)("spring_ai_alibaba_chat_memory:" + conversationId));
    }

    public void clearOverLimit(String conversationId, int maxLimit, int deleteSize) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        String key = "spring_ai_alibaba_chat_memory:" + conversationId;
        Long size = this.redisTemplate.opsForList().size((Object)key);
        if (size < (long)maxLimit) {
            return;
        }
        this.redisTemplate.opsForList().trim((Object)key, (long)deleteSize, -1L);
    }

    @Override
    public void close() {
        if (this.connectionFactory instanceof LettuceConnectionFactory) {
            ((LettuceConnectionFactory)this.connectionFactory).destroy();
            logger.info("Lettuce Redis connection pool closed");
        }
    }

    public static class RedisBuilder {
        private String host = "127.0.0.1";
        private List<String> nodes = new ArrayList<String>();
        private int port = 6379;
        private String username;
        private String password;
        private int timeout = 2000;
        private GenericObjectPoolConfig<?> poolConfig;
        private boolean useCluster = false;

        public RedisBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RedisBuilder nodes(List<String> nodes) {
            this.nodes = nodes;
            this.useCluster = true;
            return this;
        }

        public RedisBuilder port(int port) {
            this.port = port;
            return this;
        }

        public RedisBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RedisBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RedisBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public RedisBuilder poolConfig(GenericObjectPoolConfig<?> poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public LettuceRedisChatMemoryRepository build() {
            LettuceConnectionFactory lettuceConnectionFactory;
            if (this.useCluster) {
                RedisClusterConfiguration clusterConfig = new RedisClusterConfiguration(Set.copyOf(this.nodes));
                if (StringUtils.hasText((String)this.username)) {
                    clusterConfig.setUsername(this.username);
                }
                if (StringUtils.hasText((String)this.password)) {
                    clusterConfig.setPassword(this.password);
                }
                LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder clientBuilder = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(this.timeout)).poolConfig(this.poolConfig != null ? this.poolConfig : this.createDefaultPoolConfig()).clientOptions(this.createClientOptions());
                lettuceConnectionFactory = new LettuceConnectionFactory(clusterConfig, (LettuceClientConfiguration)clientBuilder.build());
            } else {
                RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration(this.host, this.port);
                if (StringUtils.hasText((String)this.username)) {
                    standaloneConfig.setUsername(this.username);
                }
                if (StringUtils.hasText((String)this.password)) {
                    standaloneConfig.setPassword(this.password);
                }
                LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder clientBuilder = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(this.timeout)).poolConfig(this.poolConfig != null ? this.poolConfig : this.createDefaultPoolConfig()).clientOptions(this.createClientOptions());
                lettuceConnectionFactory = new LettuceConnectionFactory(standaloneConfig, (LettuceClientConfiguration)clientBuilder.build());
            }
            lettuceConnectionFactory.setShareNativeConnection(false);
            lettuceConnectionFactory.afterPropertiesSet();
            return new LettuceRedisChatMemoryRepository((RedisConnectionFactory)lettuceConnectionFactory);
        }

        private GenericObjectPoolConfig<?> createDefaultPoolConfig() {
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxTotal(8);
            config.setMaxIdle(8);
            config.setMinIdle(2);
            return config;
        }

        private ClientOptions createClientOptions() {
            return ClientOptions.builder().socketOptions(SocketOptions.builder().connectTimeout(Duration.ofMillis(this.timeout)).keepAlive(true).build()).autoReconnect(true).disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build();
        }
    }
}

