/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidumap;

import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapTools;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class BaiDuMapWeatherService
implements Function<Request, Response> {
    private final BaiDuMapTools baiDuMapTools;
    private final JsonParseTool jsonParseTool;

    public BaiDuMapWeatherService(JsonParseTool jsonParseTool, BaiDuMapTools baiDuMapTools) {
        this.baiDuMapTools = baiDuMapTools;
        this.jsonParseTool = jsonParseTool;
    }

    private String getUnitRegionCode(AddressResult addressResult) {
        if (!StringUtils.hasText((String)addressResult.province())) {
            return null;
        }
        BaiDuMapTools.Region region = this.baiDuMapTools.getRegionInformation(addressResult.province(), 3);
        BaiDuMapTools.District province = Stream.of(region).map(BaiDuMapTools.Region::districts).flatMap(Collection::stream).findFirst().orElse(null);
        if (province == null) {
            return null;
        }
        String regionCode = province.code();
        BaiDuMapTools.District city = province.districts().stream().filter(d -> d.name().equals(addressResult.city())).findFirst().orElse(null);
        if (city != null && StringUtils.hasText((String)city.code())) {
            regionCode = city.code();
            BaiDuMapTools.District district = city.districts().stream().filter(d -> d.name().equals(addressResult.area())).findFirst().orElse(null);
            if (district != null && StringUtils.hasText((String)district.code())) {
                regionCode = district.code();
            }
        }
        return regionCode;
    }

    @Override
    public Response apply(Request request) {
        try {
            String regionCode;
            String addressInfoStr = this.baiDuMapTools.getAddressInformation(null, request.address(), false);
            AddressInfo addressInfo = (AddressInfo)this.jsonParseTool.jsonToObject(addressInfoStr, (TypeReference)new TypeReference<AddressInfo>(){});
            if (addressInfo.status() != 0) {
                return new Response("Get AddressWeatherInfo failed, message: " + addressInfo.message());
            }
            if (addressInfo.results() == null || addressInfo.results().isEmpty()) {
                return new Response("Get AddressWeatherInfo failed, message: Address Not Found");
            }
            AddressResult addressResult = addressInfo.results().get(0);
            String string = regionCode = addressInfo.resultType().equals("poi_type") ? this.getUnitRegionCode(addressResult) : (String)this.baiDuMapTools.getRegionInformation(addressResult.name(), 0).districts().stream().map(BaiDuMapTools.District::code).findFirst().orElse(null);
            if (!StringUtils.hasText((String)regionCode)) {
                return new Response("Get AddressWeatherInfo failed, message: RegionCode Not Found");
            }
            return new Response(this.baiDuMapTools.getWeather(regionCode));
        }
        catch (JsonProcessingException e) {
            return new Response("Invalid JSON format: " + e.getMessage());
        }
        catch (Exception e) {
            return new Response("Error occurred while processing the request: " + e.getMessage());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record AddressResult(String name, String address, String province, String city, String area) {
    }

    @JsonClassDescription(value="Get the weather conditions for a specified address.")
    public record Request(@JsonProperty(required=true, value="address") @JsonPropertyDescription(value="User-requested specific location address") String address) {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record AddressInfo(Integer status, String message, @JsonProperty(value="result_type") String resultType, List<AddressResult> results) {
    }

    public record Response(String message) {
    }
}

