/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidutranslate;

import com.alibaba.cloud.ai.toolcalling.baidutranslate.BaiduTranslateProperties;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.RestClientTool;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.DigestUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class BaiduTranslateService
implements Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(BaiduTranslateService.class);
    private static final Random random = new Random();
    private final RestClientTool restClientTool;
    private final JsonParseTool jsonParseTool;
    private final BaiduTranslateProperties properties;

    public BaiduTranslateService(BaiduTranslateProperties properties, RestClientTool restClientTool, JsonParseTool jsonParseTool) {
        this.restClientTool = restClientTool;
        this.jsonParseTool = jsonParseTool;
        this.properties = properties;
    }

    @Override
    public Response apply(Request request) {
        if (!(request != null && StringUtils.hasText((String)request.q) && StringUtils.hasText((String)request.from) && StringUtils.hasText((String)request.to))) {
            return null;
        }
        if (!StringUtils.hasText((String)this.properties.getAppId()) || !StringUtils.hasText((String)this.properties.getSecretKey())) {
            throw new RuntimeException("AppId and SecretKey is empty. Please check your configuration.");
        }
        String salt = String.valueOf(random.nextInt(100000));
        String sign = DigestUtils.md5DigestAsHex((byte[])(this.properties.getAppId() + request.q + salt + this.properties.getSecretKey()).getBytes());
        try {
            MultiValueMap body = CommonToolCallUtils.multiValueMapBuilder().add((Object)"q", (Object)request.q).add((Object)"from", (Object)request.from).add((Object)"to", (Object)request.to).add((Object)"appid", (Object)this.properties.getAppId()).add((Object)"salt", (Object)salt).add((Object)"sign", (Object)sign).build();
            return this.parseResponse(this.restClientTool.post("/", (MultiValueMap)new LinkedMultiValueMap(), new HashMap(), (Object)body, MediaType.APPLICATION_FORM_URLENCODED));
        }
        catch (Exception e) {
            logger.error("Error occurred: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Response parseResponse(String responseData) {
        try {
            HashMap<String, String> translations = new HashMap<String, String>();
            TranslationResponse responseList = (TranslationResponse)this.jsonParseTool.jsonToObject(responseData, (TypeReference)new TypeReference<TranslationResponse>(){});
            String to = responseList.to;
            List<TranslationResult> translationsList = responseList.trans_result;
            if (translationsList != null) {
                for (TranslationResult translation : translationsList) {
                    String translatedText = translation.dst;
                    translations.put(to, translatedText);
                    logger.info("Translated text to {}: {}", (Object)to, (Object)translatedText);
                }
            }
            return new Response(translations);
        }
        catch (Exception e) {
            try {
                Map responseList = this.jsonParseTool.jsonToMap(responseData, String.class);
                logger.info("Translation exception, please inquire Baidu translation api documentation to info error_code:{}", (Object)responseList);
                return new Response(responseList);
            }
            catch (Exception ex) {
                logger.error("Failed to parse json due to: {}", (Object)ex.getMessage());
                return null;
            }
        }
    }

    @JsonClassDescription(value="Request to translate text to a target language")
    public record Request(@JsonProperty(required=true, value="q") @JsonPropertyDescription(value="Content that needs to be translated") String q, @JsonProperty(required=true, value="from") @JsonPropertyDescription(value="Source language that needs to be translated") String from, @JsonProperty(required=true, value="to") @JsonPropertyDescription(value="Target language to translate into") String to) {
    }

    @JsonClassDescription(value="Response to translate text to a target language")
    public record Response(Map<String, String> translatedTexts) {
    }

    @JsonClassDescription(value="complete response")
    public record TranslationResponse(@JsonProperty(required=true, value="from") @JsonPropertyDescription(value="Source language that needs to be translated") String from, @JsonProperty(required=true, value="to") @JsonPropertyDescription(value="Target language to translate into") String to, @JsonProperty(required=true, value="trans_result") @JsonPropertyDescription(value="part of the response") List<TranslationResult> trans_result) {
    }

    @JsonClassDescription(value="part of the response")
    public record TranslationResult(@JsonProperty(required=true, value="src") @JsonPropertyDescription(value="Original Content") String src, @JsonProperty(required=true, value="dst") @JsonPropertyDescription(value="Final Result") String dst) {
    }
}

