/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.githubtoolkit;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.CreatePullRequestService;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.GetIssueService;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.GithubToolKitProperties;
import com.alibaba.cloud.ai.toolcalling.githubtoolkit.SearchRepositoryService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={GithubToolKitProperties.class})
@ConditionalOnClass(value={GithubToolKitProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.githubtoolkit", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class GithubToolKitAutoConfiguration {
    @Bean(name={"getIssue"})
    @ConditionalOnMissingBean
    @Description(value="implement the function of get a GitHub issue operation")
    public GetIssueService getIssue(GithubToolKitProperties properties, JsonParseTool jsonParseTool) {
        WebClientTool githubWebClientTool = this.githubWebClientTool(properties, jsonParseTool);
        return new GetIssueService(properties, githubWebClientTool, jsonParseTool);
    }

    @Bean(name={"createPullRequest"})
    @ConditionalOnMissingBean
    @Description(value="implement the function of create GitHub pull request operation")
    public CreatePullRequestService createPullRequest(GithubToolKitProperties properties, JsonParseTool jsonParseTool) {
        WebClientTool githubWebClientTool = this.githubWebClientTool(properties, jsonParseTool);
        return new CreatePullRequestService(properties, githubWebClientTool, jsonParseTool);
    }

    @Bean(name={"SearchRepository"})
    @ConditionalOnMissingBean
    @Description(value="implement the function of search the list of repositories operation")
    public SearchRepositoryService searchRepository(GithubToolKitProperties properties, JsonParseTool jsonParseTool) {
        WebClientTool githubWebClientTool = this.githubWebClientTool(properties, jsonParseTool);
        return new SearchRepositoryService(githubWebClientTool, jsonParseTool);
    }

    private WebClientTool githubWebClientTool(GithubToolKitProperties properties, JsonParseTool jsonParseTool) {
        return WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(headers -> {
            headers.set("User-Agent", "User-Agent");
            headers.set("Accept", "application/vnd.github.v3+json");
            headers.set("X-GitHub-Api-Version", "2022-11-28");
            headers.set("Authorization", "Bearer " + properties.getToken());
        }).build();
    }
}

