/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.api;

import com.alibaba.cloud.ai.common.R;
import com.alibaba.cloud.ai.model.ChatClient;
import com.alibaba.cloud.ai.param.ClientRunActionParam;
import com.alibaba.cloud.ai.service.ChatClientDelegate;
import com.alibaba.cloud.ai.vo.ChatClientRunResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Tag(name="chat-client", description="the chat-client API")
public interface ChatClientAPI {
    default public ChatClientDelegate getDelegate() {
        return new ChatClientDelegate(){};
    }

    @Operation(summary="list chat clients", description="", tags={"chat-client"})
    @GetMapping(value={""}, produces={"application/json"})
    default public R<List<ChatClient>> list() {
        List<ChatClient> res = this.getDelegate().list();
        return R.success(res);
    }

    @Operation(summary="get chat client by name", description="", tags={"chat-client"})
    @GetMapping(value={"/{clientName}"}, produces={"application/json"})
    default public R<ChatClient> get(@PathVariable String clientName) {
        ChatClient chatClient = this.getDelegate().get(clientName);
        return R.success(chatClient);
    }

    @Operation(summary="run chat client by input", description="", tags={"chat-client"})
    @PostMapping(value={""}, consumes={"application/json"})
    default public R<ChatClientRunResult> run(@RequestBody ClientRunActionParam runActionParam) {
        ChatClientRunResult res = this.getDelegate().run(runActionParam);
        return R.success(res);
    }
}

