/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.model;

import com.alibaba.cloud.ai.model.ChatModelConfig;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.prompt.ChatOptions;

public class ChatClient {
    @Schema(description="ChatClient bean name", examples={"chatClient", "chatClient1"})
    private String name;
    @Schema(description="Default System Text", examples={"You are a friendly chat bot that answers question in the voice of a {voice}"})
    private String defaultSystemText;
    @Schema(description="Default System Params")
    private Map<String, Object> defaultSystemParams;
    @Schema(description="ChatModel of ChatClient")
    private ChatModelConfig chatModel;
    private ChatOptions chatOptions;
    private List<Advisor> advisors;
    private Boolean isMemoryEnabled;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultSystemText() {
        return this.defaultSystemText;
    }

    public void setDefaultSystemText(String defaultSystemText) {
        this.defaultSystemText = defaultSystemText;
    }

    public Map<String, Object> getDefaultSystemParams() {
        return this.defaultSystemParams;
    }

    public void setDefaultSystemParams(Map<String, Object> defaultSystemParams) {
        this.defaultSystemParams = defaultSystemParams;
    }

    public ChatModelConfig getChatModel() {
        return this.chatModel;
    }

    public void setChatModel(ChatModelConfig chatModel) {
        this.chatModel = chatModel;
    }

    public ChatOptions getChatOptions() {
        return this.chatOptions;
    }

    public void setChatOptions(ChatOptions chatOptions) {
        this.chatOptions = chatOptions;
    }

    public List<Advisor> getAdvisors() {
        return this.advisors;
    }

    public void setAdvisors(List<Advisor> advisors) {
        this.advisors = advisors;
    }

    public Boolean getMemoryEnabled() {
        return this.isMemoryEnabled;
    }

    public void setIsMemoryEnabled(Boolean memoryEnabled) {
        this.isMemoryEnabled = memoryEnabled;
    }

    public String toString() {
        return "ChatClient{name='" + this.name + "', defaultSystemText='" + this.defaultSystemText + "', defaultSystemParams=" + this.defaultSystemParams + ", chatModel=" + this.chatModel + ", chatOptions=" + this.chatOptions + ", advisors=" + this.advisors + ", isMemoryEnabled=" + this.isMemoryEnabled + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatClient that = (ChatClient)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.defaultSystemText, that.defaultSystemText) && Objects.equals(this.defaultSystemParams, that.defaultSystemParams) && Objects.equals(this.chatModel, that.chatModel) && Objects.equals(this.chatOptions, that.chatOptions) && Objects.equals(this.advisors, that.advisors) && Objects.equals(this.isMemoryEnabled, that.isMemoryEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.defaultSystemText, this.defaultSystemParams, this.chatModel, this.chatOptions, this.advisors, this.isMemoryEnabled);
    }

    public static ChatClientBuilder builder() {
        return new ChatClientBuilder();
    }

    public static final class ChatClientBuilder {
        private String name;
        private String defaultSystemText;
        private Map<String, Object> defaultSystemParams;
        private ChatModelConfig chatModel;
        private ChatOptions chatOptions;
        private List<Advisor> advisors;
        private Boolean isMemoryEnabled;

        private ChatClientBuilder() {
        }

        public static ChatClientBuilder aChatClient() {
            return new ChatClientBuilder();
        }

        public ChatClientBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatClientBuilder defaultSystemText(String defaultSystemText) {
            this.defaultSystemText = defaultSystemText;
            return this;
        }

        public ChatClientBuilder defaultSystemParams(Map<String, Object> defaultSystemParams) {
            this.defaultSystemParams = defaultSystemParams;
            return this;
        }

        public ChatClientBuilder chatModel(ChatModelConfig chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public ChatClientBuilder chatOptions(ChatOptions chatOptions) {
            this.chatOptions = chatOptions;
            return this;
        }

        public ChatClientBuilder advisors(List<Advisor> advisors) {
            this.advisors = advisors;
            return this;
        }

        public ChatClientBuilder isMemoryEnabled(Boolean isMemoryEnabled) {
            this.isMemoryEnabled = isMemoryEnabled;
            return this;
        }

        public ChatClient build() {
            ChatClient chatClient = new ChatClient();
            chatClient.setName(this.name);
            chatClient.setDefaultSystemText(this.defaultSystemText);
            chatClient.setDefaultSystemParams(this.defaultSystemParams);
            chatClient.setChatModel(this.chatModel);
            chatClient.setChatOptions(this.chatOptions);
            chatClient.setAdvisors(this.advisors);
            chatClient.isMemoryEnabled = this.isMemoryEnabled;
            return chatClient;
        }
    }
}

