/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.oltp;

import com.alibaba.cloud.ai.oltp.StudioObservabilityProperties;
import com.alibaba.cloud.ai.service.StudioObservabilityService;
import com.alibaba.cloud.ai.service.impl.StudioObservabilityServiceImpl;
import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpFileSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(OtlpFileSpanExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final StudioObservabilityProperties studioObservabilityProperties;
    private final StudioObservabilityService studioObservabilityService;

    public static SpanExporter create() {
        return new OtlpFileSpanExporter(new StudioObservabilityProperties());
    }

    private OtlpFileSpanExporter(StudioObservabilityProperties studioObservabilityProperties) {
        this.studioObservabilityProperties = studioObservabilityProperties;
        this.studioObservabilityService = new StudioObservabilityServiceImpl(studioObservabilityProperties);
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (!this.studioObservabilityProperties.isEnabled()) {
            return CompletableResultCode.ofSuccess();
        }
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        ResourceSpansMarshaler[] allResourceSpans = ResourceSpansMarshaler.create(spans);
        return this.studioObservabilityService.export(List.of(allResourceSpans));
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
        }
        return CompletableResultCode.ofSuccess();
    }
}

