/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.impl;

import com.alibaba.cloud.ai.common.ModelType;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatModel;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.exception.ServiceInternalException;
import com.alibaba.cloud.ai.model.ChatClient;
import com.alibaba.cloud.ai.model.ChatModelConfig;
import com.alibaba.cloud.ai.param.ClientRunActionParam;
import com.alibaba.cloud.ai.service.ChatClientDelegate;
import com.alibaba.cloud.ai.service.impl.GraphServiceImpl;
import com.alibaba.cloud.ai.utils.SpringApplicationUtil;
import com.alibaba.cloud.ai.vo.ActionResult;
import com.alibaba.cloud.ai.vo.ChatClientRunResult;
import com.alibaba.cloud.ai.vo.TelemetryResult;
import io.micrometer.tracing.Tracer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.DefaultChatClient;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.BaseChatMemoryAdvisor;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ChatClientDelegateImpl
implements ChatClientDelegate {
    private static final Logger log = LoggerFactory.getLogger(GraphServiceImpl.class);
    private static final int DEFAULT_TOP_K = 100;
    private final Tracer tracer;

    public ChatClientDelegateImpl(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public List<ChatClient> list() {
        ArrayList<ChatClient> res = new ArrayList<ChatClient>();
        Map<String, org.springframework.ai.chat.client.ChatClient> chatClientMap = SpringApplicationUtil.getBeans(org.springframework.ai.chat.client.ChatClient.class);
        for (Map.Entry<String, org.springframework.ai.chat.client.ChatClient> entry : chatClientMap.entrySet()) {
            org.springframework.ai.chat.client.ChatClient chatClient = entry.getValue();
            log.info("bean name:{}, bean Class:{}", (Object)entry.getKey(), chatClient.getClass());
            ChatClient client = this.getChatClientVo(chatClient, entry.getKey());
            res.add(client);
        }
        return res;
    }

    @Override
    public ChatClient get(String clientName) {
        org.springframework.ai.chat.client.ChatClient chatClient = this.getChatClientByBeanName(clientName);
        return this.getChatClientVo(chatClient, clientName);
    }

    @Override
    public ChatClientRunResult run(ClientRunActionParam runActionParam) {
        String chatID;
        String key = runActionParam.getKey();
        String input = runActionParam.getInput();
        String prompt = runActionParam.getPrompt();
        DashScopeChatOptions chatOptions = runActionParam.getChatOptions();
        org.springframework.ai.chat.client.ChatClient chatClient = this.getChatClientByBeanName(key);
        ChatClient.ChatClientRequestSpec clientRequestSpec = chatClient.prompt();
        if (StringUtils.hasText((String)prompt)) {
            clientRequestSpec.system(prompt);
        }
        if (chatOptions != null) {
            clientRequestSpec.options((ChatOptions)chatOptions);
        }
        if (!StringUtils.hasText((String)(chatID = runActionParam.getChatID()))) {
            chatID = UUID.randomUUID().toString();
        }
        String finalChatID = chatID;
        clientRequestSpec.advisors(spec -> spec.param("chat_memory_conversation_id", (Object)finalChatID).param("chat_memory_vector_store_top_k", (Object)100));
        String resp = clientRequestSpec.user(input).call().content();
        return ChatClientRunResult.builder().input(runActionParam).result(ActionResult.builder().Response(resp).build()).ChatID(chatID).telemetry(TelemetryResult.builder().traceId(this.tracer.currentSpan().context().traceId()).build()).build();
    }

    private org.springframework.ai.chat.client.ChatClient getChatClientByBeanName(String clientName) {
        return SpringApplicationUtil.getBean(clientName, org.springframework.ai.chat.client.ChatClient.class);
    }

    private ChatClient getChatClientVo(org.springframework.ai.chat.client.ChatClient chatClient, String clientName) {
        ChatClient client = ChatClient.builder().name(clientName).build();
        if (chatClient.getClass() == DefaultChatClient.class) {
            DefaultChatClient defaultClient = (DefaultChatClient)chatClient;
            Field field = ReflectionUtils.findField(DefaultChatClient.class, (String)"defaultChatClientRequest");
            if (field != null) {
                ReflectionUtils.makeAccessible((Field)field);
                try {
                    DefaultChatClient.DefaultChatClientRequestSpec defaultChatClientRequest = (DefaultChatClient.DefaultChatClientRequestSpec)field.get(defaultClient);
                    client.setDefaultSystemText(defaultChatClientRequest.getSystemText());
                    client.setDefaultSystemParams(defaultChatClientRequest.getSystemParams());
                    client.setChatOptions(defaultChatClientRequest.getChatOptions());
                    client.setAdvisors(defaultChatClientRequest.getAdvisors());
                    for (Advisor advisor : defaultChatClientRequest.getAdvisors()) {
                        try {
                            Class<?> clazz = advisor.getClass();
                            client.setIsMemoryEnabled(BaseChatMemoryAdvisor.class.isAssignableFrom(clazz));
                        }
                        catch (Exception e) {
                            client.setIsMemoryEnabled(false);
                        }
                    }
                    Field chatModelField = ReflectionUtils.findField(DefaultChatClient.DefaultChatClientRequestSpec.class, (String)"chatModel");
                    if (chatModelField != null) {
                        ReflectionUtils.makeAccessible((Field)chatModelField);
                        try {
                            ChatModel chatModel = (ChatModel)chatModelField.get(defaultChatClientRequest);
                            ChatModelConfig model = ChatModelConfig.builder().name("chatModel").model(chatModel.getDefaultOptions().getModel()).modelType(ModelType.CHAT).build();
                            if (chatModel.getClass() == DashScopeChatModel.class) {
                                DashScopeChatModel dashScopeChatModel = (DashScopeChatModel)chatModel;
                                model.setChatOptions(dashScopeChatModel.getDashScopeChatOptions());
                            }
                            client.setChatModel(model);
                        }
                        catch (IllegalAccessException e) {
                            log.error("handle ChatModel error", (Throwable)e);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    log.error("handle DefaultChatClient error", (Throwable)e);
                    throw new ServiceInternalException(e.getMessage());
                }
            }
        }
        return client;
    }
}

