/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.common.R;
import com.alibaba.cloud.ai.oltp.StudioObservabilityProperties;
import com.alibaba.cloud.ai.service.StudioObservabilityService;
import com.alibaba.cloud.ai.service.impl.StudioObservabilityServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.logging.Logger;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"studio/api/observation"})
public class ObservationApiController {
    private static final Logger logger = Logger.getLogger(ObservationApiController.class.getName());
    private final ChatClient chatClient;
    private final ChatModel chatModel;
    private final StudioObservabilityService studioObservabilityService;

    ObservationApiController(ChatClient.Builder builder, ChatModel chatModel, StudioObservabilityProperties studioObservabilityProperties) {
        this.chatClient = builder.build();
        this.chatModel = chatModel;
        this.studioObservabilityService = new StudioObservabilityServiceImpl(studioObservabilityProperties);
    }

    @GetMapping(value={"/getAll"})
    R<ArrayNode> getAll() {
        ArrayNode res = this.studioObservabilityService.readObservabilityFile();
        return R.success(res);
    }

    @GetMapping(value={"/getAITraceInfo"})
    R<ArrayNode> getAITraceInfo() {
        ArrayNode res = this.studioObservabilityService.getAITraceInfo();
        return R.success(res);
    }

    @GetMapping(value={"/detail"})
    R<JsonNode> detail(String traceId) {
        JsonNode res = this.studioObservabilityService.getTraceByTraceId(traceId);
        return R.success(res);
    }

    @GetMapping(value={"/clearAll"})
    R<String> clearAll() {
        String res = this.studioObservabilityService.clearExportContent();
        return R.success(res);
    }

    @GetMapping(value={"/chatClient"})
    R<String> chatClient(String input) {
        String reply = this.chatClient.prompt().user(input).call().content();
        return R.success(reply);
    }

    @GetMapping(value={"/chatModel"})
    R<String> chatModel(String input) {
        String reply = this.chatModel.call(new Prompt(input)).getResult().getOutput().getText();
        return R.success(reply);
    }
}

