/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.ResponseContentWithMeta;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.http.ResponseConsumer;
import com.alicloud.openservices.tablestore.core.protocol.ResultParser;
import com.alicloud.openservices.tablestore.core.protocol.timeseries.Timeseries;
import com.alicloud.openservices.tablestore.core.protocol.timeseries.TimeseriesResponseFactory;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.List;

public class PutTimeseriesDataResponseConsumer
extends ResponseConsumer<PutTimeseriesDataResponse> {
    private PutTimeseriesDataRequest request;
    private Cache<String, Long> timeseriesMetaCache;

    public PutTimeseriesDataResponseConsumer(ResultParser resultParser, TraceLogger traceLogger, RetryStrategy retry, PutTimeseriesDataResponse lastResult, PutTimeseriesDataRequest request, Cache<String, Long> timeseriesMetaCache) {
        super(resultParser, traceLogger, retry, lastResult);
        this.request = request;
        this.timeseriesMetaCache = timeseriesMetaCache;
    }

    @Override
    protected PutTimeseriesDataResponse parseResult() throws Exception {
        List<PutTimeseriesDataResponse.FailedRowResult> failedRows;
        ResponseContentWithMeta responseContent = this.getResponseContentWithMeta();
        Timeseries.PutTimeseriesDataResponse response = (Timeseries.PutTimeseriesDataResponse)responseContent.getMessage();
        PutTimeseriesDataResponse result = TimeseriesResponseFactory.createPutTimeseriesDataResponse(responseContent, response, this.request, this.timeseriesMetaCache);
        if (this.lastResult != null) {
            result = this.mergeResult((PutTimeseriesDataResponse)this.lastResult, result);
        }
        if ((failedRows = result.getFailedRows()).isEmpty()) {
            return result;
        }
        PartialResultFailedException partialEx = new PartialResultFailedException(null, result.getRequestId(), result);
        for (PutTimeseriesDataResponse.FailedRowResult rowResult : failedRows) {
            TableStoreException ex = new TableStoreException(rowResult.getError().getMessage(), null, rowResult.getError().getCode(), result.getRequestId(), 0);
            partialEx.addError(ex);
            LogUtil.logOnFailed(this.traceLogger, this.retry, ex, result.getRequestId());
        }
        throw partialEx;
    }

    private PutTimeseriesDataResponse mergeResult(PutTimeseriesDataResponse lastResult, PutTimeseriesDataResponse result) {
        Response meta = new Response(result.getRequestId());
        meta.setTraceId(this.traceLogger.getTraceId());
        PutTimeseriesDataResponse mergedResult = new PutTimeseriesDataResponse(meta);
        List<PutTimeseriesDataResponse.FailedRowResult> lastRowResultList = lastResult.getFailedRows();
        List<PutTimeseriesDataResponse.FailedRowResult> rowResultList = result.getFailedRows();
        ArrayList<PutTimeseriesDataResponse.FailedRowResult> mergedResultList = new ArrayList<PutTimeseriesDataResponse.FailedRowResult>();
        for (PutTimeseriesDataResponse.FailedRowResult r : rowResultList) {
            int originIndex = lastRowResultList.get(r.getIndex()).getIndex();
            PutTimeseriesDataResponse.FailedRowResult mergedRowResult = new PutTimeseriesDataResponse.FailedRowResult(originIndex, r.getError());
            mergedResultList.add(mergedRowResult);
        }
        mergedResult.setFailedRows(mergedResultList);
        return mergedResult;
    }
}

