/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.DefinedColumnType;

public class DefinedColumnSchema
implements Jsonizable {
    private String name;
    private DefinedColumnType type;

    public DefinedColumnSchema(String name, DefinedColumnType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "Defined col's name should not be null or empty.");
        Preconditions.checkNotNull(type, "The type should not be null.");
        this.setName(name);
        this.setType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DefinedColumnType getType() {
        return this.type;
    }

    public void setType(DefinedColumnType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DefinedColumnSchema)) {
            return false;
        }
        DefinedColumnSchema target = (DefinedColumnSchema)o;
        return this.name.equals(target.name) && this.type == target.type;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.type);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append(String.format("{\"Name\": \"%s\", \"Type\": \"%s\"}", this.name, this.type.toString()));
    }
}

