/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;

public class DescribeStreamRequest
implements Request {
    private String streamId;
    private OptionalValue<String> inclusiveStartShardId = new OptionalValue("InclusiveStartShardId");
    private OptionalValue<Integer> shardLimit = new OptionalValue("ShardLimit");
    private boolean supportTimeseriesTable = false;

    public DescribeStreamRequest(String streamId) {
        this.setStreamId(streamId);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        Preconditions.checkArgument(streamId != null && !streamId.isEmpty(), "The streamId should not be null or empty.");
        this.streamId = streamId;
    }

    public String getInclusiveStartShardId() {
        return this.inclusiveStartShardId.getValue();
    }

    public void setInclusiveStartShardId(String inclusiveStartShardId) {
        Preconditions.checkArgument(inclusiveStartShardId != null && !inclusiveStartShardId.isEmpty(), "The inclusiveStartShardId is null or empty.");
        this.inclusiveStartShardId.setValue(inclusiveStartShardId);
    }

    public int getShardLimit() {
        if (this.shardLimit.isValueSet()) {
            return this.shardLimit.getValue();
        }
        return -1;
    }

    public void setShardLimit(int shardLimit) {
        Preconditions.checkArgument(shardLimit > 0, "The limit must be greater than 0.");
        this.shardLimit.setValue(shardLimit);
    }

    public boolean isSupportTimeseriesTable() {
        return this.supportTimeseriesTable;
    }

    public void setSupportTimeseriesTable(boolean isSupport) {
        this.supportTimeseriesTable = isSupport;
    }

    @Override
    public String getOperationName() {
        return "DescribeStream";
    }
}

