/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StreamDetails
implements Jsonizable {
    private boolean enableStream;
    private String streamId;
    private int expirationTime;
    private long lastEnableTime;
    private Set<String> originColumnsToGet = new HashSet<String>();

    public StreamDetails() {
    }

    public StreamDetails(boolean enableStream, String streamId, int expirationTime, int lastEnableTime) {
        this.setEnableStream(enableStream);
        this.setStreamId(streamId);
        this.setExpirationTime(expirationTime);
        this.setLastEnableTime(lastEnableTime);
    }

    public boolean isEnableStream() {
        return this.enableStream;
    }

    public void setEnableStream(boolean enableStream) {
        this.enableStream = enableStream;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public int getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(int expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getLastEnableTime() {
        return this.lastEnableTime;
    }

    public void setLastEnableTime(long lastEnableTime) {
        this.lastEnableTime = lastEnableTime;
    }

    public Set<String> getOriginColumnsToGet() {
        return Collections.unmodifiableSet(this.originColumnsToGet);
    }

    public void addOriginColumnsToGet(String OriginColumnName) {
        Preconditions.checkArgument(OriginColumnName != null && !OriginColumnName.isEmpty(), "OriginColumn's name should not be null or empty.");
        this.originColumnsToGet.add(OriginColumnName);
    }

    public void addOriginColumnsToGet(String[] originColumnNames) {
        Preconditions.checkNotNull(originColumnNames, "columnNames should not be null.");
        for (int i = 0; i < originColumnNames.length; ++i) {
            this.addOriginColumnsToGet(originColumnNames[i]);
        }
    }

    public void addOriginColumnsToGet(Collection<String> originColumnsToGet) {
        this.originColumnsToGet.addAll(originColumnsToGet);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        sb.append("\"EnableStream\": ");
        sb.append(this.enableStream);
        sb.append(",");
        sb.append(newline);
        sb.append("\"StreamId\": ");
        sb.append("\"" + this.streamId + "\"");
        sb.append(",");
        sb.append(newline);
        sb.append("\"ExpirationTime\": ");
        sb.append(this.expirationTime);
        sb.append(",");
        sb.append(newline);
        sb.append("\"LastEnableTime\": ");
        sb.append(this.lastEnableTime);
        sb.append(newline);
        sb.append("\"OriginColumnToGet\": ");
        sb.append(this.originColumnsToGet);
        sb.append("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EnableStream: ");
        sb.append(this.enableStream);
        sb.append(", StreamId: ");
        sb.append(this.streamId);
        sb.append(", ExpirationTime: ");
        sb.append(this.expirationTime);
        sb.append(", LastEnableTime: ");
        sb.append(this.lastEnableTime);
        sb.append(", OriginColumnToGet: ");
        sb.append(this.originColumnsToGet);
        return sb.toString();
    }
}

