/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.NumberUtils;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.util.concurrent.TimeUnit;

public class TableOptions
implements Jsonizable {
    private OptionalValue<Integer> timeToLive = new OptionalValue("TimeToLive");
    private OptionalValue<Integer> maxVersions = new OptionalValue("MaxVersions");
    private OptionalValue<Long> maxTimeDeviation = new OptionalValue("MaxTimeDeviation");
    private OptionalValue<Boolean> allowUpdate = new OptionalValue("AllowUpdate");
    private OptionalValue<Boolean> updateFullRow = new OptionalValue("UpdateFullRow");

    public TableOptions() {
    }

    public TableOptions(int timeToLive) {
        this.setTimeToLive(timeToLive);
    }

    public TableOptions(int timeToLive, int maxVersions) {
        this.setTimeToLive(timeToLive);
        this.setMaxVersions(maxVersions);
    }

    public TableOptions(int timeToLive, int maxVersions, long maxTimeDeviation) {
        this.setTimeToLive(timeToLive);
        this.setMaxVersions(maxVersions);
        this.setMaxTimeDeviation(maxTimeDeviation);
    }

    public TableOptions(boolean allowUpdate) {
        this.setAllowUpdate(allowUpdate);
    }

    public TableOptions(boolean allowUpdate, boolean updateFullRow) {
        this.setAllowUpdate(allowUpdate);
        this.setUpdateFullRow(updateFullRow);
    }

    public int getTimeToLive() {
        if (!this.timeToLive.isValueSet()) {
            throw new IllegalStateException("The value of TimeToLive is not set.");
        }
        return this.timeToLive.getValue();
    }

    public void setTimeToLive(int timeToLive) {
        Preconditions.checkArgument(timeToLive > 0 || timeToLive == -1, "The value of timeToLive can be -1 or any positive value.");
        this.timeToLive.setValue(timeToLive);
    }

    public void setTimeToLiveInDays(int days) {
        Preconditions.checkArgument(days > 0 || days == -1, "The value of timeToLive can be -1 or any positive value.");
        if (days == -1) {
            this.timeToLive.setValue(-1);
        } else {
            long seconds = TimeUnit.DAYS.toSeconds(days);
            this.timeToLive.setValue(NumberUtils.longToInt(seconds));
        }
    }

    public boolean hasSetTimeToLive() {
        return this.timeToLive.isValueSet();
    }

    public int getMaxVersions() {
        if (!this.maxVersions.isValueSet()) {
            throw new IllegalStateException("The value of MaxVersions is not set.");
        }
        return this.maxVersions.getValue();
    }

    public void setMaxVersions(int maxVersions) {
        Preconditions.checkArgument(maxVersions > 0, "MaxVersions must be greater than 0.");
        this.maxVersions.setValue(maxVersions);
    }

    public boolean hasSetMaxVersions() {
        return this.maxVersions.isValueSet();
    }

    public long getMaxTimeDeviation() {
        if (!this.maxTimeDeviation.isValueSet()) {
            throw new IllegalStateException("The value of MaxTimeDeviation is not set.");
        }
        return this.maxTimeDeviation.getValue();
    }

    public void setMaxTimeDeviation(long maxTimeDeviation) {
        Preconditions.checkArgument(maxTimeDeviation > 0L, "MaxTimeDeviation must be greater than 0.");
        this.maxTimeDeviation.setValue(maxTimeDeviation);
    }

    public boolean hasSetMaxTimeDeviation() {
        return this.maxTimeDeviation.isValueSet();
    }

    public void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate.setValue(allowUpdate);
    }

    public boolean hasSetAllowUpdate() {
        return this.allowUpdate.isValueSet();
    }

    public boolean getAllowUpdate() {
        if (!this.allowUpdate.isValueSet()) {
            throw new IllegalStateException("The value of AllowUpdate is not set.");
        }
        return this.allowUpdate.getValue();
    }

    public boolean hasSetUpdateFullRow() {
        return this.updateFullRow.isValueSet();
    }

    public boolean getUpdateFullRow() {
        if (!this.updateFullRow.isValueSet()) {
            throw new IllegalStateException("The value of UpdateFullRow is not set.");
        }
        return this.updateFullRow.getValue();
    }

    public void setUpdateFullRow(boolean updateFullRow) {
        this.updateFullRow.setValue(updateFullRow);
    }

    public String toString() {
        return this.timeToLive + ", " + this.maxVersions + ", " + this.maxTimeDeviation + ", " + this.allowUpdate + ", " + this.updateFullRow;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{");
        this.jsonizeFields(sb, true);
        sb.append("}");
    }

    protected boolean jsonizeFields(StringBuilder sb, boolean firstItem) {
        if (this.timeToLive.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"TimeToLive\": ");
            sb.append(this.timeToLive.getValue());
        }
        if (this.maxVersions.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"MaxVersions\": ");
            sb.append(this.maxVersions.getValue());
        }
        if (this.maxTimeDeviation.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"MaxTimeDeviation\": ");
            sb.append(this.maxTimeDeviation.getValue());
        }
        if (this.allowUpdate.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"AllowUpdate\": ");
            sb.append(this.allowUpdate.getValue());
        }
        if (this.updateFullRow.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"UpdateFullRow\": ");
            sb.append(this.updateFullRow.getValue());
        }
        return firstItem;
    }
}

